/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.actions;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.ide.ui.utils.operations.AbstractEditorOperation2;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.toolchain.ops.IToolOperationService;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.toolchain.ops.ToolResponse;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.StatusMessage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractEditorToolOperation<RESULT>
extends AbstractEditorOperation2<ToolResponse<RESULT>> {
    public boolean handleSoftFailureWithDialog = true;

    public AbstractEditorToolOperation(String operationName, ITextEditor editor) {
        super(operationName, editor);
    }

    public AbstractEditorToolOperation(String operationName, ITextEditor editor, SourceRange range) {
        super(operationName, editor, range);
    }

    public IToolOperationService getToolService() {
        return LangCore.getToolManager().getEngineToolsOperationService();
    }

    @Override
    protected final ToolResponse<RESULT> doBackgroundValueComputation(IOperationMonitor om) throws CommonException, OperationCancellation {
        try {
            return new ToolResponse(this.doBackgroundToolResultComputation(om));
        }
        catch (OperationSoftFailure e) {
            return new ToolResponse(null, e.getMessage());
        }
    }

    protected abstract RESULT doBackgroundToolResultComputation(IOperationMonitor var1) throws CommonException, OperationCancellation, OperationSoftFailure;

    @Override
    public void prepareAndCalculateResult() throws CommonException, OperationCancellation {
        super.prepareAndCalculateResult();
        Assert.AssertNamespace.assertNotNull((Object)((ToolResponse)this.result));
    }

    @Override
    protected void handleComputationResult(ToolResponse<RESULT> response) throws CommonException {
        String errorMessage;
        Assert.AssertNamespace.assertNotNull((Object)((ToolResponse)this.result));
        if (response.getResultData() != null) {
            this.handleResultData(response.getResultData());
        }
        if ((errorMessage = response.getStatusMessageText()) != null) {
            this.handleStatus((IStatusMessage)new StatusMessage(errorMessage));
        }
    }

    protected abstract void handleResultData(RESULT var1) throws CommonException;

    protected void handleStatus(IStatusMessage status) {
        String statusMessage = status.getMessage().trim();
        if (this.handleSoftFailureWithDialog) {
            UIOperationsStatusHandler.displayStatusMessage(this.operationName, status.getSeverity(), statusMessage);
        } else {
            EditorUtils.setStatusLineErrorMessage(this.editor, statusMessage, null);
            Display.getCurrent().beep();
        }
    }
}

