/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.actions;

import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.utils.operations.BasicUIOperation;
import melnorme.utilbox.core.Assert;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractEditorHandler
extends AbstractHandler {
    protected final IWorkbenchPage page;

    public AbstractEditorHandler(IWorkbenchPage page) {
        this.page = (IWorkbenchPage)Assert.AssertNamespace.assertNotNull((Object)page);
    }

    protected Shell getShell() {
        return this.page.getWorkbenchWindow().getShell();
    }

    protected ITextEditor getTextEditor() {
        IEditorPart activeEditor = this.page.getActiveEditor();
        if (activeEditor instanceof ITextEditor) {
            return (ITextEditor)activeEditor;
        }
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled() && EditorSettings_Actual.editorKlass().isInstance(this.page.getActiveEditor());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextEditor editor = (ITextEditor)HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        Assert.AssertNamespace.assertNotNull((Object)editor);
        this.createOperation(editor).executeAndHandle();
        return null;
    }

    protected abstract BasicUIOperation createOperation(ITextEditor var1);
}

