/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.ExternalBreakpointWatcher;
import melnorme.lang.ide.ui.editor.LangEditorContextMenuContributor;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.ownership.IOwner;
import melnorme.utilbox.ownership.OwnedObjects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.services.IServiceLocator;

public class TextEditorExt
extends TextEditor {
    protected final IOwner owned = new OwnedObjects();
    protected ExternalBreakpointWatcher breakpointWatcher;
    protected LangEditorContextMenuContributor editorActionsManager;

    protected <T extends IDisposable> T addOwned(T disposable) {
        this.owned.bind(disposable);
        return disposable;
    }

    public void dispose() {
        this.owned.disposeAll();
        super.dispose();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.owned.disposeOwned((IDisposable)this.breakpointWatcher);
        this.breakpointWatcher = null;
        if (input == null) {
            return;
        }
        IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel((Object)input);
        IFile file = EditorUtils.getAssociatedFile(input);
        if (file != null) {
            return;
        }
        this.breakpointWatcher = new ExternalBreakpointWatcher(input, this.getDocument(), annotationModel);
        this.owned.bind((IDisposable)this.breakpointWatcher);
    }

    protected IDocument getDocument() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    public void setStatusLineErrorMessage(String message) {
        super.setStatusLineErrorMessage(message);
    }

    public void setTitleImage(Image titleImage) {
        super.setTitleImage(titleImage);
    }

    protected void createActions() {
        super.createActions();
        this.editorActionsManager = this.createActionsManager();
    }

    protected LangEditorContextMenuContributor createActionsManager() {
        return EditorSettings_Actual.createCommandsContribHelper((IServiceLocator)this.getSite().getWorkbenchWindow());
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.editorContextMenuAboutToShow_extend(menu);
    }

    protected void editorContextMenuAboutToShow_extend(IMenuManager menu) {
        this.editorActionsManager.editorContextMenuAboutToShow(menu);
    }

    public boolean isActivePart() {
        return WorkbenchUtils.getActivePart(this.getSite()) == this;
    }

    public Location getInputLocation() throws CommonException {
        return EditorUtils.getLocationFromEditorInput(this.getEditorInput());
    }
}

