/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import melnorme.lang.ide.core.TextSettings_Actual;
import melnorme.lang.ide.core.text.ISourceBufferExt;
import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.LangSourceViewer;
import melnorme.lang.ide.ui.text.LangSourceViewerConfiguration;
import melnorme.lang.tooling.common.ISourceBuffer;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;

public class LangTextMergeViewer
extends TextMergeViewer {
    private int sourceViewerNumber = 0;

    public LangTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        int styles = textOrientation | 0x100 | 0x200;
        return new LangSourceViewer(parent, (IVerticalRuler)new CompositeRuler(), styles);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return TextSettings_Actual.createDocumentSetupHelper().createDocumentPartitioner();
    }

    protected String getDocumentPartitioning() {
        return "___go_partioning";
    }

    public String getTitle() {
        return "Go Source Compare";
    }

    public IPreferenceStore getPreferenceStore() {
        return LangUIPlugin.getDefault().getCombinedPreferenceStore();
    }

    protected void createControls(Composite composite) {
        IContextService service;
        super.createControls(composite);
        ICompareContainer container = this.getCompareConfiguration().getContainer();
        IWorkbenchPart workbenchPart = container.getWorkbenchPart();
        if (workbenchPart != null && (service = (IContextService)workbenchPart.getSite().getService(IContextService.class)) != null) {
            service.activateContext(EditorSettings_Actual.EDITOR_CONTEXT_ID);
        }
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            SourceViewer sourceViewer = (SourceViewer)textViewer;
            sourceViewer.configure(this.getSourceViewerConfiguration((ISourceViewer)sourceViewer));
        } else {
            super.configureTextViewer(textViewer);
        }
        this.sourceViewerNumber = (this.sourceViewerNumber + 1) % 3;
    }

    protected SourceViewerConfiguration getSourceViewerConfiguration(ISourceViewer sourceViewer) {
        SourceViewerSourceBuffer sourceBuffer = this.sourceViewerNumber == 0 ? new SourceViewerSourceBuffer(sourceViewer) : (this.sourceViewerNumber == 1 ? new SourceViewerSourceBuffer(sourceViewer){

            @Override
            public Location getLocation_orNull() {
                return EditorUtils.getLocationOrNull(LangTextMergeViewer.this.getEditorInput(this.sourceViewer));
            }

            @Override
            public boolean isDirty() {
                return LangTextMergeViewer.this.isLeftDirty();
            }
        } : new SourceViewerSourceBuffer(sourceViewer){

            @Override
            public Location getLocation_orNull() {
                return EditorUtils.getLocationOrNull(LangTextMergeViewer.this.getEditorInput(this.sourceViewer));
            }
        });
        return new LangSourceViewerConfiguration(this.getPreferenceStore(), sourceBuffer, null);
    }

    public static class SourceViewerSourceBuffer
    implements ISourceBufferExt {
        protected final ISourceViewer sourceViewer;

        public SourceViewerSourceBuffer(ISourceViewer sourceViewer) {
            this.sourceViewer = sourceViewer;
        }

        public Location getLocation_orNull() {
            return null;
        }

        public IDocument getDocument() {
            return (IDocument)Assert.AssertNamespace.assertNotNull((Object)this.sourceViewer.getDocument());
        }

        public boolean isDirty() {
            return true;
        }

        public void doTrySaveBuffer() throws CommonException {
            throw new CommonException("Cannot save document for this source buffer");
        }

        public ISourceBuffer getReadOnlyView() {
            return this;
        }
    }
}

