/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import melnorme.lang.ide.core.text.TextSourceUtils;
import melnorme.lang.ide.ui.editor.ISourceViewerExt;
import melnorme.lang.ide.ui.editor.ProjectionViewerExt;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.NumberUtil;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class LangSourceViewer
extends ProjectionViewerExt
implements ISourceViewerExt {
    protected IInformationPresenter outlinePresenter;

    public LangSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        super(parent, verticalRuler, null, false, styles);
        this.addConfigurationOwned(new IDisposable(){

            public void dispose() {
                if (LangSourceViewer.this.outlinePresenter != null) {
                    LangSourceViewer.this.outlinePresenter.uninstall();
                    LangSourceViewer.this.outlinePresenter = null;
                }
            }
        });
    }

    public LangSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.addConfigurationOwned(new /* invalid duplicate definition of identical inner class */);
    }

    public boolean canDoOperation(int operation) {
        if (this.getTextWidget() == null) {
            return false;
        }
        switch (operation) {
            case 9: {
                return this.isEditable() && this.fIndentChars != null;
            }
            case 8: {
                return this.isEditable() && this.fIndentChars != null && (this.areMultipleLinesSelected() || this.isCursorAtIndent());
            }
        }
        return super.canDoOperation(operation);
    }

    protected boolean isCursorAtIndent() {
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        Point sel = this.getSelectedRange();
        try {
            int startLine = document.getLineOfOffset(sel.x);
            IRegion line = document.getLineInformation(startLine);
            int lineStart = line.getOffset();
            String indent = TextSourceUtils.getLineIndentForLine((String)document.get(), (IRegion)line);
            return NumberUtil.isInRange((int)lineStart, (int)sel.x, (int)(lineStart + indent.length()));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void shift(boolean useDefaultPrefixes, boolean right, boolean ignoreWhitespace) {
        Point selection = this.getSelectedRange();
        super.shift(useDefaultPrefixes, right, ignoreWhitespace);
        Point newSelection = this.getSelectedRange();
        if (selection.y == 0 && selection.x == newSelection.x) {
            this.setSelectedRange(selection.x + newSelection.y, 0);
        }
    }

    public void setOutlinePresenter(IInformationPresenter outlinePresenter) {
        this.outlinePresenter = outlinePresenter;
    }

    @Override
    public void showOutline() throws CommonException {
        if (this.outlinePresenter == null) {
            throw new CommonException("Outline not available. ", null);
        }
        this.outlinePresenter.showInformation();
    }

    @Override
    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }
}

