/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import java.util.Iterator;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.ownership.IOwner;
import melnorme.utilbox.ownership.LifecycleObject;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ExternalBreakpointWatcher
extends LifecycleObject {
    protected static final String CBREAKPOINT_MARKER_TYPE = "org.eclipse.cdt.debug.core.cLineBreakpointMarker";
    protected static final String ATTRIBUTE_SOURCE_HANDLE = "requestedSourceHandle";
    protected final Location location;
    protected final IDocument document;
    protected final IAnnotationModel annotationModel;
    protected final IAnnotationModelExtension annotationModelExt;
    protected final IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResource res = delta.getResource();
            if (res instanceof IWorkspaceRoot && (delta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] markerDeltas;
                IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
                int n = markerDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                    int kind = markerDelta.getKind();
                    if (markerDelta.isSubtypeOf(ExternalBreakpointWatcher.CBREAKPOINT_MARKER_TYPE)) {
                        if (kind == 1) {
                            ExternalBreakpointWatcher.this.addMarkerAnnotation(markerDelta.getMarker());
                        }
                        if (kind == 2) {
                            ExternalBreakpointWatcher.this.removeMarkerAnnotation(markerDelta.getMarker());
                        }
                        if (kind == 4) {
                            ExternalBreakpointWatcher.this.updateMarkerAnnotation(markerDelta.getMarker());
                        }
                    }
                    ++n2;
                }
            }
        }
    };

    public ExternalBreakpointWatcher(IEditorInput input, IDocument document, IAnnotationModel annotationModel) {
        this.location = EditorUtils.getLocationOrNull(input);
        this.document = (IDocument)Assert.AssertNamespace.assertNotNull((Object)document);
        this.annotationModel = (IAnnotationModel)Assert.AssertNamespace.assertNotNull((Object)annotationModel);
        this.annotationModelExt = annotationModel instanceof IAnnotationModelExtension ? (IAnnotationModelExtension)annotationModel : null;
        if (this.location != null) {
            ResourceUtils.connectResourceListener((IResourceChangeListener)this.resourceListener, this::initializeFromResources, (ISchedulingRule)ResourceUtils.getWorkspaceRoot(), (IOwner)this.owned);
        }
    }

    protected void initializeFromResources() throws CoreException {
        IMarker[] findMarkers;
        IMarker[] iMarkerArray = findMarkers = ResourceUtils.getWorkspaceRoot().findMarkers(CBREAKPOINT_MARKER_TYPE, true, 0);
        int n = findMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.addMarkerAnnotation(marker);
            ++n2;
        }
    }

    protected void addMarkerAnnotation(IMarker marker) {
        int markerOffset;
        try {
            String sourceHandle = marker.getAttribute(ATTRIBUTE_SOURCE_HANDLE, null);
            if (sourceHandle == null) {
                return;
            }
            Location markerLocation = Location.create((String)sourceHandle);
            if (!markerLocation.equals((Object)this.location)) {
                return;
            }
        }
        catch (CommonException e) {
            return;
        }
        try {
            markerOffset = this.getMarkerPosition(marker);
        }
        catch (BadLocationException e) {
            return;
        }
        Position position = new Position(markerOffset, 0);
        MarkerAnnotation annotation = new MarkerAnnotation(marker);
        this.annotationModel.addAnnotation((Annotation)annotation, position);
    }

    protected int getMarkerPosition(IMarker marker) throws BadLocationException {
        int line = MarkerUtilities.getLineNumber((IMarker)marker);
        if (line > 0) {
            return this.document.getLineOffset(line - 1);
        }
        throw new BadLocationException();
    }

    protected void removeMarkerAnnotation(IMarker marker) {
        Iterator iter = this.annotationModel.getAnnotationIterator();
        for (Annotation ann : () -> iter) {
            MarkerAnnotation markerAnnotation;
            if (!(ann instanceof MarkerAnnotation) || !(markerAnnotation = (MarkerAnnotation)ann).getMarker().equals((Object)marker)) continue;
            this.annotationModel.removeAnnotation((Annotation)markerAnnotation);
            return;
        }
    }

    protected void updateMarkerAnnotation(IMarker marker) {
        Iterator iter = this.annotationModel.getAnnotationIterator();
        for (Annotation ann : () -> iter) {
            MarkerAnnotation markerAnnotation;
            if (!(ann instanceof MarkerAnnotation) || !(markerAnnotation = (MarkerAnnotation)ann).getMarker().equals((Object)marker)) continue;
            Position position = this.annotationModel.getPosition((Annotation)markerAnnotation);
            this.annotationModelExt.modifyAnnotationPosition((Annotation)markerAnnotation, position);
            return;
        }
    }
}

