/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtils {
    public static IDocument getEditorDocument(ITextEditor textEditor) {
        return textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
    }

    public static TextSelection getSelection(ITextEditor editor) {
        return (TextSelection)editor.getSelectionProvider().getSelection();
    }

    public static SourceRange getSelectionSR(ITextEditor editor) {
        TextSelection sel = EditorUtils.getSelection(editor);
        return new SourceRange(sel.getOffset(), sel.getLength());
    }

    public static void setEditorSelection(ITextEditor textEditor, SourceRange sourceRange) {
        EditorUtils.setEditorSelection(textEditor, sourceRange.getOffset(), sourceRange.getLength());
    }

    public static void setEditorSelection(ITextEditor textEditor, int offset, int length) {
        textEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, length));
    }

    public static IProject getAssociatedProject(IEditorInput input) {
        if (input == null) {
            return null;
        }
        IResource resource = EditorUtils.getAssociatedResource(input);
        if (resource != null) {
            return resource.getProject();
        }
        return null;
    }

    public static IResource getAssociatedResource(IEditorInput input) {
        if (input == null) {
            return null;
        }
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource != null) {
            return resource;
        }
        return (IProject)input.getAdapter(IProject.class);
    }

    public static IFile getAssociatedFile(IEditorInput editorInput) {
        return ResourceUtil.getFile((IEditorInput)editorInput);
    }

    public static IFile findFileOfEditor(IEditorPart editor) {
        return EditorUtils.getAssociatedFile(editor.getEditorInput());
    }

    public static IEditorInput getBestEditorInputForLoc(Location fileLoc) {
        return EditorUtils.getBestEditorInputForUri(fileLoc.toUri());
    }

    public static IEditorInput getBestEditorInputForUri(URI uri) {
        return EditorUtils.getBestEditorInputForUri(uri, 0);
    }

    public static IEditorInput getBestEditorInputForUri(URI uri, int memberFlags) {
        IFile[] files = ResourceUtils.getWorkspaceRoot().findFilesForLocationURI(uri, memberFlags);
        if (files.length != 0) {
            IFile file = files[0];
            return new FileEditorInput(file);
        }
        IFileStore fileOnLocalDisk = EFS.getLocalFileSystem().getStore(uri);
        return new FileStoreEditorInput(fileOnLocalDisk);
    }

    public static Path getFilePathFromEditorInput(IEditorInput editorInput) {
        IURIEditorInput uriEditorInput = editorInput instanceof IURIEditorInput ? (IURIEditorInput)editorInput : (IURIEditorInput)editorInput.getAdapter(IURIEditorInput.class);
        if (uriEditorInput != null && uriEditorInput.getURI() != null) {
            try {
                return Paths.get(uriEditorInput.getURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (editorInput instanceof IStorageEditorInput) {
            IStorageEditorInput storageEditorInput = (IStorageEditorInput)editorInput;
            try {
                IPath fullPath = storageEditorInput.getStorage().getFullPath();
                if (fullPath != null) {
                    return fullPath.toFile().toPath();
                }
            }
            catch (CoreException ce) {
                EclipseCore.logStatus((CoreException)ce);
            }
        }
        return null;
    }

    public static Location getLocationFromEditorInput(IEditorInput editorInput) throws CommonException {
        Path filePath = EditorUtils.getFilePathFromEditorInput(editorInput);
        if (filePath == null) {
            throw new CommonException("Error: Could not determine file path for editor.", null);
        }
        return Location.createValidLocation((Path)filePath, (String)"Invalid editorInput path: ");
    }

    public static Location getLocationOrNull(IEditorInput editorInput) {
        try {
            return EditorUtils.getLocationFromEditorInput(editorInput);
        }
        catch (CommonException e) {
            return null;
        }
    }

    public static Location getInputLocationOrNull(IEditorPart editor) {
        Path inputPath = EditorUtils.getFilePathFromEditorInput(editor.getEditorInput());
        return Location.createValidOrNull((Path)inputPath);
    }

    public static Location getInputLocation(IEditorPart editor) throws CommonException {
        Location inputLocationOrNull = EditorUtils.getInputLocationOrNull(editor);
        if (inputLocationOrNull == null) {
            throw new CommonException("Error, invalid location for editor input.");
        }
        return inputLocationOrNull;
    }

    public static IEditorPart openEditor(IEditorInput newInput, String editorId) throws PartInitException {
        return EditorUtils.openEditor(newInput, editorId, false);
    }

    public static IEditorPart openEditor(IEditorInput newInput, String editorId, boolean reuseExisitingEditor) throws PartInitException {
        IWorkbenchPage page = WorkbenchUtils.getActiveWorkbenchWindow().getActivePage();
        int matchFlags = reuseExisitingEditor ? 1 : 0;
        return page.openEditor(newInput, editorId, true, matchFlags);
    }

    public static ITextEditor openTextEditorAndSetSelection(String editorId, IEditorInput newInput, SourceRange sourceRange) throws CoreException {
        return EditorUtils.openTextEditorAndSetSelection(null, editorId, newInput, OpenNewEditorMode.ALWAYS, sourceRange);
    }

    public static ITextEditor openTextEditorAndSetSelection(ITextEditor currentEditor, String editorId, IEditorInput newInput, OpenNewEditorMode openNewEditor, SourceRange selectionRange) throws PartInitException, CoreException {
        ITextEditor editor = EditorUtils.openTextEditor(currentEditor, editorId, newInput, openNewEditor);
        if (selectionRange != null) {
            EditorUtils.setEditorSelection(editor, selectionRange);
        }
        return editor;
    }

    public static ITextEditor openTextEditor(ITextEditor currentEditor, String editorId, IEditorInput newInput, OpenNewEditorMode openNewEditor) throws PartInitException, CoreException {
        int matchFlags;
        IEditorPart editor;
        ITextEditor targetEditor;
        IWorkbenchPage page;
        if (currentEditor == null) {
            page = WorkbenchUtils.getActivePage();
            openNewEditor = OpenNewEditorMode.ALWAYS;
        } else {
            page = currentEditor.getEditorSite().getWorkbenchWindow().getActivePage();
        }
        if (openNewEditor == OpenNewEditorMode.NEVER) {
            if (currentEditor.getEditorInput().equals(newInput)) {
                return currentEditor;
            }
            if (currentEditor instanceof IReusableEditor) {
                IReusableEditor reusableEditor = (IReusableEditor)currentEditor;
                reusableEditor.setInput(newInput);
                return currentEditor;
            }
            openNewEditor = OpenNewEditorMode.ALWAYS;
        }
        if ((targetEditor = (ITextEditor)CoreUtil.tryCast((Object)(editor = page.openEditor(newInput, editorId, true, matchFlags = openNewEditor == OpenNewEditorMode.ALWAYS ? 0 : 3)), ITextEditor.class)) == null) {
            throw EclipseCore.createCoreException((String)"Not a text editor", null);
        }
        return targetEditor;
    }

    public static void setStatusLineErrorMessage(ITextEditor editor, String message, Image image) {
        IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, message, image);
        }
    }

    public static SourceRange getSelectedRange(ITextViewer viewer) {
        Point selectedRange = viewer.getSelectedRange();
        return new SourceRange(selectedRange.x, selectedRange.y);
    }

    public static final IRegion getSignedSelection(ITextViewer sourceViewer) {
        Point viewerSelection = sourceViewer.getSelectedRange();
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            viewerSelection.x += viewerSelection.y;
            viewerSelection.y = -viewerSelection.y;
        }
        return new Region(viewerSelection.x, viewerSelection.y);
    }

    public static enum OpenNewEditorMode {
        ALWAYS,
        TRY_REUSING_EXISTING,
        NEVER;

    }
}

