/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.dialogs;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ProjectValidator;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.dialogs.WizardMessages;
import melnorme.lang.ide.ui.utils.DialogPageUtils;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.util.swt.SWTFactory;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.CompositeWidget;
import melnorme.util.swt.components.fields.DirectoryTextField;
import melnorme.util.swt.components.fields.EnablementButtonTextField;
import melnorme.util.swt.components.fields.TextFieldWidget;
import melnorme.util.swt.components.misc.StatusMessageWidget;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.fields.IFieldView;
import melnorme.utilbox.fields.validation.ValidationSource;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class LangProjectWizardFirstPage
extends WizardPage {
    protected final NameGroup nameGroup = this.createNameGroup();
    protected final LocationGroup locationGroup = this.createLocationGroup();
    protected final ProjectValidationGroup projectValidationGroup = this.createProjectValidationGroup();
    protected final PreferencesValidationGroup prefValidationGroup = this.createPreferencesValidationGroup();

    public LangProjectWizardFirstPage() {
        super(LangProjectWizardFirstPage.class.getSimpleName());
    }

    public LangProjectWizardFirstPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected NameGroup createNameGroup() {
        return new NameGroup();
    }

    protected ProjectValidationGroup createProjectValidationGroup() {
        return new ProjectValidationGroup();
    }

    protected LocationGroup createLocationGroup() {
        return new LocationGroup();
    }

    protected PreferencesValidationGroup createPreferencesValidationGroup() {
        return new PreferencesValidationGroup();
    }

    public NameGroup getNameGroup() {
        return this.nameGroup;
    }

    public LocationGroup getLocationGroup() {
        return this.locationGroup;
    }

    public ProjectValidationGroup getDetectGroup() {
        return this.projectValidationGroup;
    }

    public IPath getProjectLocation() {
        return this.locationGroup.getProjectLocation();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topControl = new Composite(parent, 0);
        topControl.setLayoutData((Object)new GridData(1808));
        topControl.setLayout((Layout)new GridLayout(1, false));
        this.createContents(topControl);
        this.setControl((Control)topControl);
        Dialog.applyDialogFont((Control)topControl);
    }

    protected GridDataFactory sectionGDF() {
        return GridDataFactory.fillDefaults().grab(true, false);
    }

    protected void createContents(Composite parent) {
        this.nameGroup.createComponent(parent, this.sectionGDF().create());
        this.locationGroup.createComponent(parent, this.sectionGDF().create());
        this.createContents_ValidationGroups(parent);
        FieldValueListener.FieldChangeListener listener = this::validateDialog;
        this.nameGroup.textField.addChangeListener(listener);
        this.locationGroup.addChangeListener(listener);
        this.validateDialog();
    }

    protected void createContents_ValidationGroups(Composite parent) {
        this.projectValidationGroup.createComponent(parent, this.sectionGDF().hint(500, -1).create());
        this.prefValidationGroup.createComponent(parent, this.sectionGDF().hint(500, -1).create());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameGroup.postSetFocus();
        }
    }

    public IProject getProjectHandle2() throws CommonException {
        return this.nameGroup.getProjectHandle2();
    }

    protected void validatePreferences() throws StatusException {
        LangCore.settings().SDK_LOCATION.getValue();
    }

    protected boolean validateDialog() {
        boolean valid;
        IStatusMessage validationStatus = this.getValidationStatus();
        if (validationStatus == null) {
            this.setMessage(null);
            this.setPageComplete(true);
            valid = true;
        } else {
            Severity severity = validationStatus.getSeverity();
            this.setMessage(validationStatus.getMessage(), DialogPageUtils.severityToMessageType(severity));
            this.setPageComplete(severity != Severity.ERROR);
            valid = false;
        }
        this.projectValidationGroup.updateWidgetFromInput();
        this.prefValidationGroup.updateWidgetFromInput();
        return valid;
    }

    protected IStatusMessage getValidationStatus() {
        try {
            this.nameGroup.validate();
            this.locationGroup.validate();
            return null;
        }
        catch (StatusException e) {
            return e;
        }
    }

    public class LocationGroup
    extends EnablementButtonTextField {
        public LocationGroup() {
            super(WizardMessages.LangNewProject_Location_Directory_label, "Use default location.", WizardMessages.LangNewProject_Location_Directory_buttonLabel);
            LangProjectWizardFirstPage.this.nameGroup.getNameField().addChangeListener(this::updateDefaultFieldValue);
            this.addFieldValidationX(true, () -> this.doValidate());
        }

        protected String getProjectName() {
            return LangProjectWizardFirstPage.this.nameGroup.getName();
        }

        protected boolean isDefaultLocation() {
            return this.isUseDefault();
        }

        protected String getLocationString() {
            return (String)this.getFieldValue();
        }

        @Override
        protected String getDefaultFieldValue() {
            return Platform.getLocation().append(this.getProjectName()).toOSString();
        }

        public IPath getProjectLocation() {
            String projectName = this.getProjectName();
            if (projectName.isEmpty()) {
                return null;
            }
            if (!Path.EMPTY.isValidPath(this.getLocationString())) {
                return null;
            }
            return Path.fromOSString((String)this.getLocationString());
        }

        public void doValidate() throws StatusException {
            IProject project = LangProjectWizardFirstPage.this.nameGroup.getProjectHandle2();
            if (project.exists() && !this.isDefaultLocation()) {
                throw new StatusException(Severity.ERROR, "Project already exists, cannot change location.");
            }
            IPath projectLocation = this.getProjectLocation();
            if (projectLocation == null) {
                throw new StatusException(Severity.ERROR, "Invalid project location.");
            }
            EclipseUtils.validate(() -> ResourceUtils.getWorkspace().validateProjectLocation(project, projectLocation));
        }

        @Override
        protected Composite doCreateTopLevelControl(Composite parent) {
            return SWTFactoryUtil.createGroup(parent, "Location:");
        }

        @Override
        public int getPreferredLayoutColumns() {
            return 3;
        }

        @Override
        protected void createContents_Label(Composite parent) {
            this.label = SWTFactory.createLabel(parent, 0, this.labelText);
        }

        @Override
        protected String getNewValueFromButtonSelection() throws OperationCancellation {
            return DirectoryTextField.openDirectoryDialog((String)this.getFieldValue(), this.button.getShell());
        }
    }

    public static class NameGroup
    extends CompositeWidget {
        protected TextFieldWidget textField = new TextFieldWidget("&Project name:");

        public NameGroup() {
            super(true);
            this.addChildWidget(this.textField);
            this.layoutColumns = 2;
            ValidationSource.ValidationSourceX validationSource = this::validateProjectName;
            this.validation.addFieldValidation(true, (IFieldView)this.textField, (ValidationSource)validationSource);
        }

        public String getName() {
            return (String)this.textField.getFieldValue();
        }

        public TextFieldWidget getNameField() {
            return this.textField;
        }

        public void validateProjectName() throws StatusException {
            this.getProjectHandle2();
        }

        public IProject getProjectHandle2() throws StatusException {
            return new ProjectValidator().getProjectHandle(this.getName());
        }

        public void postSetFocus() {
            SWTUtil.post_setFocus(this.textField.getFieldControl());
        }
    }

    public class PreferencesValidationGroup
    extends ProjectValidationGroup {
        @Override
        protected void createContents(Composite parent) {
            super.createContents(parent);
            this.hintText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencesValidationGroup.this.openPreferencePage();
                }
            });
        }

        protected void openPreferencePage() {
            WorkbenchUtils.openPreferencePage(LangProjectWizardFirstPage.this.getShell(), "com.googlecode.goclipse.ui.PreferencePages.Root");
            this.updateWidgetFromInput();
        }

        @Override
        public void updateWidgetFromInput() {
            try {
                LangProjectWizardFirstPage.this.validatePreferences();
                this.setStatusMessage(null);
            }
            catch (CommonException ve) {
                this.setPreferencesErrorMessage(ve);
            }
        }

        protected void setPreferencesErrorMessage(CommonException ve) {
            this.setStatusMessage(Severity.WARNING, "The Go preferences have not been configured correctly.\n<a>Click here to configure preferences...</a>");
        }
    }

    public class ProjectValidationGroup
    extends StatusMessageWidget {
        @Override
        public void updateWidgetFromInput() {
            IProject projectHandle;
            try {
                projectHandle = LangProjectWizardFirstPage.this.getProjectHandle2();
            }
            catch (CommonException e) {
                projectHandle = null;
            }
            IPath projectLoc = LangProjectWizardFirstPage.this.getProjectLocation();
            if (projectHandle != null && projectHandle.exists()) {
                this.setStatusMessage(Severity.INFO, WizardMessages.LangNewProject_DetectGroup_projectExists);
            } else if (projectLoc != null && projectLoc.toFile().exists()) {
                this.setStatusMessage(Severity.INFO, "A directory already exists at the specified location. The wizard will try to detect an existing external project, or convert the existing directory into a new project.");
            } else {
                this.setStatusMessage(null);
            }
        }
    }
}

