/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.build;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.build.AbstractDebugCheckboxSelectionDialog;
import melnorme.lang.ide.ui.build.EnvironmentVariable;
import melnorme.lang.ide.ui.build.LaunchConfigurationsMessages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

class NativeEnvironmentSelectionDialog
extends AbstractDebugCheckboxSelectionDialog {
    private Object fInput;

    public NativeEnvironmentSelectionDialog(Shell parentShell, Object input) {
        super(parentShell);
        this.fInput = input;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setShowSelectAllButtons(true);
    }

    @Override
    protected String getDialogSettingsId() {
        return "com.googlecode.goclipse.core.ENVIRONMENT_TAB.NATIVE_ENVIROMENT_DIALOG";
    }

    @Override
    protected String getHelpContextId() {
        return null;
    }

    @Override
    protected Object getViewerInput() {
        return this.fInput;
    }

    @Override
    protected String getViewerLabel() {
        return LaunchConfigurationsMessages.EnvironmentTab_19;
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return LangImages.IMG_ENVIRONMENT.getImage();
            }

            public String getText(Object element) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                return MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_7, var.getName(), var.getValue());
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                EnvironmentVariable[] elements = null;
                if (inputElement instanceof HashMap) {
                    Comparator<Object> comparator = new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            String s1 = (String)o1;
                            String s2 = (String)o2;
                            return s1.compareTo(s2);
                        }
                    };
                    TreeMap envVars = new TreeMap(comparator);
                    envVars.putAll((Map)inputElement);
                    elements = new EnvironmentVariable[envVars.size()];
                    int index = 0;
                    for (Object key : envVars.keySet()) {
                        elements[index] = (EnvironmentVariable)envVars.get(key);
                        ++index;
                    }
                }
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }
}

