/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.build;

import _org.eclipse.debug.internal.ui.MultipleInputDialog;
import _org.eclipse.debug.internal.ui.SWTFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.build.EnvironmentSettingsEditor_Base;
import melnorme.lang.ide.ui.build.EnvironmentVariable;
import melnorme.lang.ide.ui.build.LaunchConfigurationsMessages;
import melnorme.lang.ide.ui.build.NativeEnvironmentSelectionDialog;
import melnorme.lang.tooling.commands.EnvironmentSettings;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.AbstractWidget;
import melnorme.utilbox.core.Assert;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EnvironmentSettingsEditor
extends EnvironmentSettingsEditor_Base {
    protected static final String[] envTableColumnHeaders = new String[]{"Variable", "Value"};
    private static final String NAME_LABEL = "&Name:";
    private static final String VALUE_LABEL = "&Value:";
    protected static final String P_VARIABLE = "variable";
    protected static final String P_VALUE = "value";
    protected TableViewer environmentTable;
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected Button appendEnvironment;
    protected Button replaceEnvironment;
    protected Button envSelectButton;

    public EnvironmentSettingsEditor() {
        super(false);
        this.layoutColumns = 2;
        this.field().set((Object)new EnvironmentSettings());
        this.field().addListener(newValue -> {
            Object object = Assert.AssertNamespace.assertNotNull((Object)newValue);
        });
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        super.doSetEnabled(enabled);
        if (this.environmentTable == null) {
            return;
        }
        EnvironmentSettingsEditor.setControlEnabled((Control)this.environmentTable.getTable(), enabled);
        EnvironmentSettingsEditor.setControlEnabled((Control)this.envAddButton, enabled);
        EnvironmentSettingsEditor.setControlEnabled((Control)this.envEditButton, enabled);
        EnvironmentSettingsEditor.setControlEnabled((Control)this.envRemoveButton, enabled);
        EnvironmentSettingsEditor.setControlEnabled((Control)this.appendEnvironment, enabled);
        EnvironmentSettingsEditor.setControlEnabled((Control)this.replaceEnvironment, enabled);
        EnvironmentSettingsEditor.setControlEnabled((Control)this.envSelectButton, enabled);
    }

    @Override
    protected void createContents(Composite topControl) {
        super.createContents(topControl);
        this.createEnvironmentTable(topControl);
        this.createTableButtons(topControl);
        this.createAppendReplace(topControl);
        Dialog.applyDialogFont((Control)topControl);
    }

    protected void createAppendReplace(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 2, 768);
        this.appendEnvironment = SWTFactory.createRadioButton(comp, LaunchConfigurationsMessages.EnvironmentTab_16);
        this.appendEnvironment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((EnvironmentSettings)EnvironmentSettingsEditor.this.field().get()).appendEnv = EnvironmentSettingsEditor.this.appendEnvironment.getSelection();
                EnvironmentSettingsEditor.this.notifyFieldChanged();
            }
        });
        this.replaceEnvironment = SWTFactory.createRadioButton(comp, LaunchConfigurationsMessages.EnvironmentTab_17);
        this.field().addListener(true, newValue -> {
            if (SWTUtil.isOkToUse((Control)this.appendEnvironment)) {
                this.appendEnvironment.setSelection(newValue.appendEnv);
                this.replaceEnvironment.setSelection(!newValue.appendEnv);
            }
        });
    }

    protected void createEnvironmentTable(Composite parent) {
        Font font = parent.getFont();
        SWTFactory.createLabel(parent, LaunchConfigurationsMessages.EnvironmentTab_Environment_variables_to_set__3, 2);
        Composite tableComposite = SWTFactory.createComposite(parent, font, 1, 1, 1808, 0, 0);
        this.environmentTable = new TableViewer(tableComposite, 68354);
        Table table = this.environmentTable.getTable();
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)AbstractWidget.gdGrabAll(400, 200));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.environmentTable.setContentProvider((IContentProvider)new EnvironmentSettingsEditor_Base.EnvironmentVariableContentProvider(this));
        this.environmentTable.setLabelProvider((IBaseLabelProvider)new EnvironmentVariableLabelProvider());
        this.environmentTable.setColumnProperties(new String[]{P_VARIABLE, P_VALUE});
        this.environmentTable.setComparator(new ViewerComparator(){

            public int compare(Viewer iviewer, Object e1, Object e2) {
                if (e1 == null) {
                    return -1;
                }
                if (e2 == null) {
                    return 1;
                }
                return ((EnvironmentVariable)e1).getName().compareToIgnoreCase(((EnvironmentVariable)e2).getName());
            }
        });
        this.environmentTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EnvironmentSettingsEditor.this.handleTableSelectionChanged(event);
            }
        });
        this.environmentTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!EnvironmentSettingsEditor.this.environmentTable.getSelection().isEmpty()) {
                    EnvironmentSettingsEditor.this.handleEnvEditButtonSelected();
                }
            }
        });
        final TableColumn tc1 = new TableColumn(table, 0, 0);
        tc1.setText(envTableColumnHeaders[0]);
        final TableColumn tc2 = new TableColumn(table, 0, 1);
        tc2.setText(envTableColumnHeaders[1]);
        final Table tref = table;
        final Composite comp = tableComposite;
        tableComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = comp.getClientArea();
                Point size = tref.computeSize(-1, -1);
                ScrollBar vBar = tref.getVerticalBar();
                int width = area.width - tref.computeTrim((int)0, (int)0, (int)0, (int)0).width - 2;
                if (size.y > area.height + tref.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tref.getSize();
                if (oldSize.x > area.width) {
                    tc1.setWidth(width / 2 - 1);
                    tc2.setWidth(width - tc1.getWidth());
                    tref.setSize(area.width, area.height);
                } else {
                    tref.setSize(area.width, area.height);
                    tc1.setWidth(width / 2 - 1);
                    tc2.setWidth(width - tc1.getWidth());
                }
            }
        });
        this.field().addListener(true, newValue -> {
            if (SWTUtil.isOkToUse((Control)this.environmentTable.getTable())) {
                this.environmentTable.setInput(this.field().get());
                this.environmentTable.refresh();
            }
        });
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
    }

    protected void createTableButtons(Composite parent) {
        Composite buttonComposite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 130, 0, 0);
        this.envAddButton = SWTFactory.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_New_4, null);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentSettingsEditor.this.handleEnvAddButtonSelected();
            }
        });
        this.envSelectButton = SWTFactory.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_18, null);
        this.envSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentSettingsEditor.this.handleEnvSelectButtonSelected();
            }
        });
        this.envEditButton = SWTFactory.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Edit_5, null);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentSettingsEditor.this.handleEnvEditButtonSelected();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = SWTFactory.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Remove_6, null);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentSettingsEditor.this.handleEnvRemoveButtonSelected();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    protected void handleEnvAddButtonSelected() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_22);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addVariablesField(VALUE_LABEL, null, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            this.addVariable(new EnvironmentVariable(name.trim(), value.trim()));
        }
    }

    protected boolean addVariable(EnvironmentVariable variable) {
        String name = variable.getName();
        if (((EnvironmentSettings)this.getFieldValue()).envVars.containsKey((Object)name)) {
            boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchConfigurationsMessages.EnvironmentTab_12, (String)MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_13, name));
            if (!overWrite) {
                return false;
            }
            ((EnvironmentSettings)this.getFieldValue()).envVars.remove((Object)name);
        }
        ((EnvironmentSettings)this.getFieldValue()).envVars.put((Object)name, (Object)variable.getValue());
        this.notifyFieldChanged();
        return true;
    }

    private void handleEnvSelectButtonSelected() {
        Map<String, EnvironmentVariable> envVariables = this.getNativeEnvironment();
        for (String varName : ((EnvironmentSettings)this.getFieldValue()).envVars.keySet()) {
            envVariables.remove(varName);
        }
        NativeEnvironmentSelectionDialog dialog = new NativeEnvironmentSelectionDialog(this.getShell(), envVariables);
        dialog.setTitle(LaunchConfigurationsMessages.EnvironmentTab_20);
        int button = dialog.open();
        if (button == 0) {
            Object[] selected = dialog.getResult();
            int i = 0;
            while (i < selected.length) {
                EnvironmentVariable envVar = (EnvironmentVariable)selected[i];
                ((EnvironmentSettings)this.getFieldValue()).envVars.put((Object)envVar.getName(), (Object)envVar.getValue());
                ++i;
            }
        }
        this.notifyFieldChanged();
    }

    protected Map<String, EnvironmentVariable> getNativeEnvironment() {
        Map stringVars = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        for (Map.Entry entry : stringVars.entrySet()) {
            vars.put((String)entry.getKey(), new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue()));
        }
        return vars;
    }

    private void handleEnvEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        EnvironmentVariable originalVar = (EnvironmentVariable)sel.getFirstElement();
        if (originalVar == null) {
            return;
        }
        String originalName = originalVar.getName();
        String value = originalVar.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_11);
        dialog.addTextField(NAME_LABEL, originalName, false);
        if (value != null && value.indexOf(System.getProperty("line.separator")) > -1) {
            dialog.addMultilinedVariablesField(VALUE_LABEL, value, true);
        } else {
            dialog.addVariablesField(VALUE_LABEL, value, true);
        }
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        value = dialog.getStringValue(VALUE_LABEL);
        if (!originalName.equals(name)) {
            if (this.addVariable(new EnvironmentVariable(name, value))) {
                ((EnvironmentSettings)this.getFieldValue()).envVars.remove((Object)originalVar.getName());
                this.notifyFieldChanged();
            }
        } else {
            ((EnvironmentSettings)this.getFieldValue()).envVars.put((Object)name, (Object)value);
            this.notifyFieldChanged();
        }
    }

    private void handleEnvRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        for (EnvironmentVariable var : sel) {
            ((EnvironmentSettings)this.getFieldValue()).envVars.remove((Object)var.getName());
        }
        this.notifyFieldChanged();
    }

    protected void notifyFieldChanged() {
        this.field().fireFieldValueChanged();
    }

    public class EnvironmentVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getName();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                        break;
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return LangImages.IMG_ENV_VAR.getImage();
            }
            return null;
        }
    }
}

