/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.build;

import melnorme.lang.ide.core.operations.build.VariablesResolver;
import melnorme.lang.ide.ui.build.EnvironmentSettingsEditor;
import melnorme.lang.ide.ui.fields.FieldDialog;
import melnorme.lang.ide.ui.utils.ControlUtils;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.lang.tooling.commands.EnvironmentSettings;
import melnorme.lang.tooling.commands.IVariablesResolver;
import melnorme.util.swt.components.ButtonWidget;
import melnorme.util.swt.components.CompositeWidget;
import melnorme.util.swt.components.fields.EnablementCompositeWidget;
import melnorme.util.swt.components.fields.SetFieldValueOperation;
import melnorme.util.swt.components.fields.TextFieldWidget;
import melnorme.utilbox.collections.MapAccess;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.CommonGetter;
import melnorme.utilbox.fields.Field;
import melnorme.utilbox.status.StatusException;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CommandInvocationEditor
extends EnablementCompositeWidget<CommandInvocation> {
    protected final Field<CommandInvocation> commandInvocation;
    protected final CommonGetter<CommandInvocation> getDefaultArguments;
    protected final VariablesResolver variablesResolver;
    protected final TextFieldWidget commandArgumentsField;

    public CommandInvocationEditor(CommonGetter<CommandInvocation> getDefaultCommandInvocation, VariablesResolver variablesResolver) {
        super("Command Invocation:", "Use default value.");
        this.createInlined = false;
        this.commandInvocation = this.field();
        this.getDefaultArguments = getDefaultCommandInvocation;
        this.variablesResolver = variablesResolver;
        this.commandArgumentsField = this.init_createButtonTextField();
        this.commandArgumentsField.addFieldValidationX(true, this::validateArguments);
        this.commandArgumentsField.onlyValidateWhenEnabled = false;
        this.addChildWidget(this.commandArgumentsField);
        this.commandArgumentsField.addChangeListener(this::updateCommandInvocationField);
        this.createButtonArea();
        this.commandInvocation.addChangeListener(this::updateWidgetFromInput);
    }

    public TextFieldWidget getCommandArgumentsWidget() {
        return this.commandArgumentsField;
    }

    @Override
    protected void doUpdateWidgetFromInput() {
        CommandInvocation commandInvocation = (CommandInvocation)this.commandInvocation.get();
        if (commandInvocation == null) {
            this.commandArgumentsField.set("");
            return;
        }
        this.commandArgumentsField.set(commandInvocation.getCommandLine());
    }

    protected void updateCommandInvocationField() {
        CommandInvocation current = (CommandInvocation)this.commandInvocation.get();
        if (current == null) {
            return;
        }
        this.commandInvocation.set((Object)new CommandInvocation((String)this.commandArgumentsField.get(), current.getEnvironmentVars(), current.isAppendEnvironment()));
    }

    @Override
    protected CommandInvocation getDefaultFieldValue() throws CommonException {
        return (CommandInvocation)this.getDefaultArguments.get();
    }

    protected void createButtonArea() {
        ButtonWidget environmentVarButton = new ButtonWidget("Edit Environment variables...", this::handleEditEnvironmentVars);
        final ButtonWidget variablesDialogButton = new ButtonWidget("Insert/Edit Substitution Variables...", new SetFieldValueOperation<String>(this.commandArgumentsField, this::newValueFromCommandVariablesDialog));
        CompositeWidget buttonArea = this.addChildWidget(new CompositeWidget(false){
            {
                super($anonymous0);
                this.layoutColumns = 2;
            }

            @Override
            protected void createContents(Composite topControl) {
                super.createContents(topControl);
                GridData layoutData = (GridData)variablesDialogButton.getButton().getLayoutData();
                layoutData.grabExcessHorizontalSpace = true;
                layoutData.horizontalAlignment = 3;
            }
        });
        buttonArea.addChildWidget(environmentVarButton);
        buttonArea.addChildWidget(variablesDialogButton);
    }

    protected TextFieldWidget init_createButtonTextField() {
        TextFieldWidget buttonTextField = new TextFieldWidget(null){

            @Override
            protected void createContents_layout() {
                this.text.setLayoutData((Object)2.gdGrabAll(40, 100));
            }
        };
        buttonTextField.setMultiLineStyle();
        return buttonTextField;
    }

    protected void validateArguments() throws StatusException {
        CommandInvocation fieldValue = (CommandInvocation)this.getFieldValue();
        if (fieldValue == null) {
            return;
        }
        fieldValue.validate((IVariablesResolver)this.variablesResolver);
    }

    protected String newValueFromCommandVariablesDialog() throws OperationCancellation {
        StringVariableSelectionDialog variablesDialog = new StringVariableSelectionDialog(this.commandArgumentsField.getFieldControl().getShell());
        variablesDialog.setElements(this.variablesResolver.getVariables());
        String addedVar = ControlUtils.openStringVariableSelectionDialog(variablesDialog);
        return String.valueOf((String)this.commandArgumentsField.getFieldValue()) + addedVar;
    }

    protected void handleEditEnvironmentVars() {
        Shell shell = this.getCommandArgumentsWidget().getFieldControl().getShell();
        CommandInvocation cmd = (CommandInvocation)this.getFieldValue();
        EnvironmentSettings envSettings = new EnvironmentSettings(cmd.getEnvironmentVars().copyToHashMap(), cmd.isAppendEnvironment());
        try {
            envSettings = new FieldDialog<EnvironmentSettings>(shell, new EnvironmentSettingsEditor()).openDialog(envSettings);
        }
        catch (OperationCancellation e) {
            return;
        }
        this.setFieldValue(new CommandInvocation(cmd.getCommandLine(), (MapAccess)envSettings.envVars.copy(), envSettings.appendEnv));
    }
}

