/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.build;

import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.VariablesResolver;
import melnorme.lang.ide.ui.build.CommandInvocationEditor;
import melnorme.lang.ide.ui.utils.ControlUtils;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.util.swt.components.CompositeWidget;
import melnorme.util.swt.components.fields.CheckBoxField;
import melnorme.util.swt.components.fields.EnablementButtonTextField;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.CommonGetter;
import melnorme.utilbox.status.StatusException;

public class BuildTargetEditor
extends CompositeWidget {
    protected final BuildManager buildManager;
    protected final CheckBoxField normalEnableField;
    protected final CheckBoxField autoEnableField;
    protected final CommonGetter<CommandInvocation> getDefaultBuildCommand;
    public final CommandInvocationEditor buildCommandField;
    protected final CommonGetter<String> getDefaultProgramPath;
    public final EnablementButtonTextField programPathField;
    protected BuildTargetData btData = new BuildTargetData();

    public BuildTargetEditor(BuildManager buildManager, boolean createEnablementFields, CommonGetter<CommandInvocation> getDefaultBuildCommand, CommonGetter<String> getDefaultProgramPath) {
        super(false);
        this.buildManager = (BuildManager)Assert.AssertNamespace.assertNotNull((Object)buildManager);
        this.getDefaultBuildCommand = (CommonGetter)Assert.AssertNamespace.assertNotNull(getDefaultBuildCommand);
        this.getDefaultProgramPath = (CommonGetter)Assert.AssertNamespace.assertNotNull(getDefaultProgramPath);
        this.normalEnableField = new CheckBoxField("Enable for workspace build");
        this.normalEnableField.addListener(newValue -> {
            boolean bl = this.btData.normalBuildEnabled = newValue.booleanValue();
        });
        this.autoEnableField = new CheckBoxField("Enable for auto-check (invoke on editor save)");
        this.autoEnableField.addListener(newValue -> {
            boolean bl = this.btData.autoBuildEnabled = newValue.booleanValue();
        });
        if (createEnablementFields) {
            this.addChildWidget(this.normalEnableField, this.autoEnableField);
        }
        this.buildCommandField = this.addChildWidget(this.init_createArgumentsField());
        this.buildCommandField.addEffectiveValueChangeListener(() -> {
            this.btData.buildCommand = this.getEffectiveBuildCommand();
        });
        this.programPathField = this.addChildWidget(this.init_createProgramPathField());
        this.programPathField.addListener(__ -> {
            String string = this.btData.executablePath = this.getEffectiveProgramPathValue();
        });
    }

    protected BuildManager getBuildManager() {
        return this.buildManager;
    }

    protected CommandInvocationEditor init_createArgumentsField() {
        VariablesResolver varResolver = this.buildManager.getToolManager().getVariablesManager(null);
        return new BuildCommandEditor(this.getDefaultBuildCommand, varResolver);
    }

    protected EnablementButtonTextField init_createProgramPathField() {
        return new ProgramPathField();
    }

    public CommandInvocation getEffectiveBuildCommand() {
        return (CommandInvocation)this.buildCommandField.getEffectiveFieldValue();
    }

    public String getEffectiveProgramPathValue() {
        return this.programPathField.getEffectiveFieldValue();
    }

    public void setInput(BuildTargetData buildTargetData) {
        this.btData = buildTargetData;
        this.normalEnableField.setFieldValue(buildTargetData.isNormalBuildEnabled());
        this.autoEnableField.setFieldValue(buildTargetData.isAutoBuildEnabled());
        this.buildCommandField.setEffectiveFieldValue(buildTargetData.getBuildCommand());
        this.programPathField.setEffectiveFieldValue(buildTargetData.getExecutablePath());
    }

    public static class BuildCommandEditor
    extends CommandInvocationEditor {
        public BuildCommandEditor(CommonGetter<CommandInvocation> getDefaultBuildCommand, VariablesResolver variablesResolver) {
            super(getDefaultBuildCommand, variablesResolver);
            this.label = "Build Command:";
        }

        @Override
        protected void validateArguments() throws StatusException {
            block2: {
                try {
                    super.validateArguments();
                }
                catch (StatusException se) {
                    if (se.getMessage() != "No command specified.") break block2;
                    throw new StatusException("No build command supplied.");
                }
            }
        }
    }

    public class ProgramPathField
    extends EnablementButtonTextField {
        public ProgramPathField() {
            super("(Optional) Path of generated executable:", "Use default:", "Variables...");
        }

        @Override
        protected String getDefaultFieldValue() throws CommonException {
            return (String)BuildTargetEditor.this.getDefaultProgramPath.get();
        }

        @Override
        protected String getNewValueFromButtonSelection() throws CommonException, OperationCancellation {
            return String.valueOf((String)this.getFieldValue()) + ControlUtils.openStringVariableSelectionDialog(this.text.getShell());
        }
    }
}

