/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.build;

import _org.eclipse.debug.internal.ui.SWTFactory;
import java.util.List;
import melnorme.lang.ide.ui.LangUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

abstract class AbstractDebugSelectionDialog
extends SelectionDialog {
    public static String EMPTY_STRING = "";
    protected StructuredViewer fViewer = null;

    public AbstractDebugSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setDialogBoundsSettings(this.getDialogBoundsSettings(), 2);
    }

    protected abstract String getDialogSettingsId();

    protected abstract Object getViewerInput();

    protected abstract StructuredViewer createViewer(Composite var1);

    protected abstract boolean isValid();

    protected IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    protected abstract IBaseLabelProvider getLabelProvider();

    protected abstract String getHelpContextId();

    protected void addViewerListeners(StructuredViewer viewer) {
    }

    protected void addCustomHeaderControls(Composite parent) {
    }

    protected void addCustomFooterControls(Composite parent) {
    }

    protected void initializeControls() {
        this.getButton(0).setEnabled(this.isValid());
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        this.initializeControls();
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = (Composite)super.createDialogArea(parent);
        this.addCustomHeaderControls(comp);
        String label = this.getMessage();
        if (label != null && !EMPTY_STRING.equals(label)) {
            SWTFactory.createWrapLabel(comp, label, 1);
        }
        if ((label = this.getViewerLabel()) != null && !EMPTY_STRING.equals(label)) {
            SWTFactory.createLabel(comp, label, 1);
        }
        this.fViewer = this.createViewer(comp);
        this.fViewer.setLabelProvider(this.getLabelProvider());
        this.fViewer.setContentProvider(this.getContentProvider());
        this.fViewer.setInput(this.getViewerInput());
        List selectedElements = this.getInitialElementSelections();
        if (selectedElements != null && !selectedElements.isEmpty()) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(selectedElements));
        }
        this.addViewerListeners(this.fViewer);
        this.addCustomFooterControls(comp);
        Dialog.applyDialogFont((Control)comp);
        String help = this.getHelpContextId();
        if (help != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, help);
        }
        return comp;
    }

    protected abstract String getViewerLabel();

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = LangUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsId());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsId());
        }
        return section;
    }
}

