/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui;

import java.util.Dictionary;
import java.util.Hashtable;
import melnorme.lang.ide.ui.LangUI;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.ownership.LifecycleObject;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;

public class ThemeHelper
extends LifecycleObject
implements IDisposable {
    protected final BundleContext context;
    protected final ServiceReference<?> serviceRef;
    protected final IThemeManager themeManager;

    public ThemeHelper(BundleContext context) {
        this.context = context;
        this.serviceRef = context.getServiceReference(IThemeManager.class.getName());
        this.asOwner().bind(() -> {
            boolean bl = context.ungetService(this.serviceRef);
        });
        this.themeManager = (IThemeManager)CoreUtil.blindCast((Object)context.getService(this.serviceRef));
    }

    public ITheme getActiveThemeForCurrentDisplay() {
        IThemeEngine engine = this.themeManager.getEngineForDisplay(Display.getCurrent());
        return engine.getActiveTheme();
    }

    public String getIdOfActiveThemeForCurrentDisplay() {
        ITheme activeTheme = this.getActiveThemeForCurrentDisplay();
        return activeTheme == null ? "" : activeTheme.getId();
    }

    public static abstract class ThemeChangeListener
    implements EventHandler,
    IDisposable {
        protected final BundleContext context = LangUI.getInstance().getBundleContext();
        protected final ServiceRegistration<?> svcRegistration;

        public ThemeChangeListener() {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("event.topics", "org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged");
            this.svcRegistration = this.context.registerService(EventHandler.class, (Object)this, properties);
        }

        public void dispose() {
            this.svcRegistration.unregister();
        }
    }
}

