/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui;

import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.utils.PluginImagesHelper;
import melnorme.util.swt.jface.resources.ImageDescriptorRegistry;
import melnorme.utilbox.core.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public abstract class LangImages {
    protected static final String IMAGES_BUNDLE_PREFIX = "$nl$/icons/";
    protected static final IPath IMAGES_PATH = new Path("$nl$/icons/");
    protected static final PluginImagesHelper helper = new PluginImagesHelper(LangUIPlugin.getInstance().getBundle(), IMAGES_PATH, true);
    public static final String ICONS = "icons-lang/";
    public static final String LANG_ACTIONS = "icons-lang/actions/";
    public static final String LANG_OVERLAYS = "icons-lang/overlays/";
    public static final String LANG_NAVIGATOR = "icons-lang/navigator/";
    public static final String CAT_VIEWS = "views";
    protected static final String T_TABS = "view16";
    public static final PluginImagesHelper.ImageHandle ACTIONS_OPEN_DEF = LangImages.createManaged("icons-lang/actions/", "OpenDef.16.png");
    public static final PluginImagesHelper.ImageHandle BUILD_CONSOLE_ICON;
    public static final PluginImagesHelper.ImageHandle ENGINE_TOOLS_CONSOLE_ICON;
    public static final PluginImagesHelper.ImageHandle SOURCE_EDITOR_ICON;
    public static final PluginImagesHelper.ImageHandle BUILD_TARGET;
    public static final PluginImagesHelper.ImageHandle BUILD_TARGETS_ELEM;
    public static final PluginImagesHelper.ImageHandle IMG_LAUNCHTAB_MAIN;
    public static final PluginImagesHelper.ImageHandle IMG_LAUNCHTAB_ARGUMENTS;
    public static final PluginImagesHelper.ImageHandle IMG_SCROLL_LOCK;
    public static final PluginImagesHelper.ImageHandle IMG_CLEAR_CONSOLE;
    public static final PluginImagesHelper.ImageHandle IMG_PIN_CONSOLE;
    public static final PluginImagesHelper.ImageHandle IMG_ENV_VAR;
    public static final PluginImagesHelper.ImageHandle IMG_ENVIRONMENT;
    public static final ImageDescriptor DESC_OVR_ERROR;
    public static final ImageDescriptor DESC_OVR_WARNING;
    public static final ImageDescriptor DESC_OVR_PRIVATE;
    public static final ImageDescriptor DESC_OVR_PROTECTED;
    public static final ImageDescriptor DESC_OVR_DEFAULT;
    public static final ImageDescriptor DESC_OVR_PRIVATE_SMALL;
    public static final ImageDescriptor DESC_OVR_PROTECTED_SMALL;
    public static final ImageDescriptor DESC_OVR_DEFAULT_SMALL;
    public static final ImageDescriptor DESC_OVR_FINAL;
    public static final ImageDescriptor DESC_OVR_STATIC;
    public static final ImageDescriptor DESC_OVR_ABSTRACT;
    public static final ImageDescriptor DESC_OVR_CONST;
    public static final ImageDescriptor DESC_OVR_IMMUTABLE;
    public static final ImageDescriptor DESC_OVR_TEMPLATED;
    public static final ImageDescriptor DESC_OVR_ALIAS;
    public static final ImageDescriptor OVR_CHECKED;
    public static final ImageDescriptor OVR_BUILD_NORMAL_CHECKED;
    public static final ImageDescriptor OVR_BUILD_AUTO_CHECKED;
    public static final ImageDescriptor OVR_BUILD_BOTH_CHECKED;
    public static final ImageDescriptor NAV_Error;
    public static final ImageDescriptor NAV_Library;
    public static final ImageDescriptor NAV_LibraryNative;
    public static final ImageDescriptor NAV_OutputFolder;
    public static final ImageDescriptor NAV_OutputFolder2;
    public static final ImageDescriptor NAV_Package;
    public static final ImageDescriptor NAV_PackageManifest;
    public static final ImageDescriptor NAV_SourceFolder;
    public static final ImageDescriptor NAV_SourceFolderTests;
    public static final ImageDescriptor BREAKPOINT_ENABLED;
    public static final ImageDescriptor BREAKPOINT_DISABLED;

    static {
        ENGINE_TOOLS_CONSOLE_ICON = BUILD_CONSOLE_ICON = LangImages.createManaged(CAT_VIEWS, "ToolsConsole.16.png");
        SOURCE_EDITOR_ICON = LangImages.createManaged(CAT_VIEWS, "SourceEditor.png");
        BUILD_TARGET = LangImages.createManaged(CAT_VIEWS, "target.png");
        BUILD_TARGETS_ELEM = LangImages.createManaged(CAT_VIEWS, "targets_elem.png");
        IMG_LAUNCHTAB_MAIN = LangImages.createManaged(T_TABS, "main_launch_tab.png");
        IMG_LAUNCHTAB_ARGUMENTS = LangImages.createManaged(T_TABS, "arguments_tab.gif");
        IMG_SCROLL_LOCK = LangImages.createManaged(LANG_ACTIONS, "lock_co.png");
        IMG_CLEAR_CONSOLE = LangImages.createManaged(LANG_ACTIONS, "clear_co.png");
        IMG_PIN_CONSOLE = LangImages.createManaged(LANG_ACTIONS, "pin.png");
        IMG_ENV_VAR = LangImages.createManaged(ICONS, "envvar_obj.png");
        IMG_ENVIRONMENT = LangImages.createManaged(ICONS, "environment_obj.png");
        DESC_OVR_ERROR = LangImages.createUnmanaged(LANG_OVERLAYS, "error.png");
        DESC_OVR_WARNING = LangImages.createUnmanaged(LANG_OVERLAYS, "warning.png");
        DESC_OVR_PRIVATE = LangImages.createUnmanaged(LANG_OVERLAYS, "prot_private.png");
        DESC_OVR_PROTECTED = LangImages.createUnmanaged(LANG_OVERLAYS, "prot_protected.png");
        DESC_OVR_DEFAULT = LangImages.createUnmanaged(LANG_OVERLAYS, "prot_default.png");
        DESC_OVR_PRIVATE_SMALL = LangImages.createUnmanaged(LANG_OVERLAYS, "prot_private.2.png");
        DESC_OVR_PROTECTED_SMALL = LangImages.createUnmanaged(LANG_OVERLAYS, "prot_protected.2.png");
        DESC_OVR_DEFAULT_SMALL = LangImages.createUnmanaged(LANG_OVERLAYS, "prot_default.2.png");
        DESC_OVR_FINAL = LangImages.createUnmanaged(LANG_OVERLAYS, "ovr_final.png");
        DESC_OVR_STATIC = LangImages.createUnmanaged(LANG_OVERLAYS, "ovr_static.png");
        DESC_OVR_ABSTRACT = LangImages.createUnmanaged(LANG_OVERLAYS, "ovr_abstract.png");
        DESC_OVR_CONST = LangImages.createUnmanaged(LANG_OVERLAYS, "ovr_const.png");
        DESC_OVR_IMMUTABLE = LangImages.createUnmanaged(LANG_OVERLAYS, "ovr_immutable.png");
        DESC_OVR_TEMPLATED = LangImages.createUnmanaged(LANG_OVERLAYS, "ovr_templated.png");
        DESC_OVR_ALIAS = LangImages.createUnmanaged(LANG_OVERLAYS, "ovr_alias_arrow.png");
        OVR_CHECKED = LangImages.createUnmanaged(LANG_OVERLAYS, "ovr_checked.png");
        OVR_BUILD_NORMAL_CHECKED = LangImages.createUnmanaged(LANG_OVERLAYS, "build_normal_enabled.png");
        OVR_BUILD_AUTO_CHECKED = LangImages.createUnmanaged(LANG_OVERLAYS, "build_auto_enabled.png");
        OVR_BUILD_BOTH_CHECKED = LangImages.createUnmanaged(LANG_OVERLAYS, "build_both_enabled.png");
        NAV_Error = LangImages.createUnmanaged(LANG_NAVIGATOR, "Error.png");
        NAV_Library = LangImages.createUnmanaged(LANG_NAVIGATOR, "Library.png");
        NAV_LibraryNative = LangImages.createUnmanaged(LANG_NAVIGATOR, "LibraryNative.png");
        NAV_OutputFolder = LangImages.createUnmanaged(LANG_NAVIGATOR, "OutputFolder.png");
        NAV_OutputFolder2 = LangImages.createUnmanaged(LANG_NAVIGATOR, "OutputFolder2.png");
        NAV_Package = LangImages.createUnmanaged(LANG_NAVIGATOR, "Package.png");
        NAV_PackageManifest = LangImages.createUnmanaged(LANG_NAVIGATOR, "PackageManifest.png");
        NAV_SourceFolder = LangImages.createUnmanaged(LANG_NAVIGATOR, "SourceFolder.png");
        NAV_SourceFolderTests = LangImages.createUnmanaged(LANG_NAVIGATOR, "SourceFolder_Tests2.png");
        BREAKPOINT_ENABLED = LangImages.createUnmanaged(ICONS, "brkp_obj.png");
        BREAKPOINT_DISABLED = LangImages.createUnmanaged(ICONS, "brkpd_obj.png");
    }

    protected static String getKey(String prefix, String name) {
        return String.valueOf(prefix) + "/" + name;
    }

    public static PluginImagesHelper.ImageHandle createManaged(String prefix, String name) {
        return LangImages.createManaged(LangImages.getKey(prefix, name));
    }

    public static PluginImagesHelper.ImageHandle createManaged(String imagePath) {
        return helper.createManaged(imagePath);
    }

    protected static PluginImagesHelper.ImageHandle createFromPlatformSharedImage(String prefix, String name, String sharedImageName) {
        ImageDescriptor descriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(sharedImageName);
        String key = LangImages.getKey(prefix, name);
        return helper.putManaged(key, descriptor);
    }

    protected static ImageDescriptor createUnmanaged(String prefix, String name) {
        return helper.createImageDescriptor(LangImages.getKey(prefix, name), false);
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        Assert.AssertNamespace.assertTrue((LangUIPlugin.getStandardDisplay() != null ? 1 : 0) != 0);
        return LangUIPlugin.getDefault().getImageDescriptorRegistry();
    }

    public static Image getManagedImage(ImageDescriptor imageDescriptor) {
        return LangImages.getImageDescriptorRegistry().get(imageDescriptor);
    }
}

