/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.wizards;

import com.googlecode.goclipse.ui.wizards.DialogChangeListener;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewSourceFileComposite
extends Composite {
    private Text sourceFolderName;
    private Text sourceFilename;
    private SourceFileType sourceFileType = SourceFileType.PACKAGE_FILE;
    private WeakHashMap<DialogChangeListener, DialogChangeListener> dialogChangeListeners = new WeakHashMap();

    public NewSourceFileComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblSourceFolder = new Label((Composite)this, 0);
        lblSourceFolder.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSourceFolder.setText("Source Folder:");
        this.sourceFolderName = new Text((Composite)this, 2048);
        GridData gd_sourceFolderName = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_sourceFolderName.widthHint = 263;
        this.sourceFolderName.setLayoutData((Object)gd_sourceFolderName);
        this.sourceFolderName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSourceFileComposite.this.fireDialogChange();
            }
        });
        Button browseButton = new Button((Composite)this, 0);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSourceFileComposite.this.handleBrowse();
            }
        });
        Label lblSourceFilename = new Label((Composite)this, 0);
        lblSourceFilename.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSourceFilename.setText("Source FIle:");
        this.sourceFilename = new Text((Composite)this, 2048);
        GridData gd_sourceFilename = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_sourceFilename.widthHint = 263;
        this.sourceFilename.setLayoutData((Object)gd_sourceFilename);
        this.sourceFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSourceFileComposite.this.fireDialogChange();
            }
        });
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        Group grpSourceFileType = new Group((Composite)this, 0);
        grpSourceFileType.setText("Source File Type");
        grpSourceFileType.setLayout((Layout)new GridLayout(1, false));
        GridData gd_grpSourceFileType = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_grpSourceFileType.widthHint = 273;
        grpSourceFileType.setLayoutData((Object)gd_grpSourceFileType);
        final Button btnPackageSourceFile = new Button((Composite)grpSourceFileType, 16);
        btnPackageSourceFile.setSelection(true);
        btnPackageSourceFile.setText("Package Source File");
        btnPackageSourceFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.eval();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.eval();
            }

            public void eval() {
                if (btnPackageSourceFile.getSelection()) {
                    NewSourceFileComposite.this.sourceFileType = SourceFileType.MAIN_DEFAULT;
                    NewSourceFileComposite.this.sourceFilename.setText(NewSourceFileComposite.this.getNewFileName(NewSourceFileComposite.this.sourceFilename.getText(), false));
                }
            }
        });
        final Button btnCommandSourceFile = new Button((Composite)grpSourceFileType, 16);
        GridData gd_btnCommandSourceFile = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnCommandSourceFile.widthHint = 258;
        btnCommandSourceFile.setLayoutData((Object)gd_btnCommandSourceFile);
        btnCommandSourceFile.setText("Command Source File");
        final CCombo combo = new CCombo((Composite)grpSourceFileType, 2048);
        combo.setItems(new String[]{"Empty Main Function", "Main Function with Parameters", "Simple Web Server"});
        combo.select(0);
        combo.setEnabled(false);
        combo.setEditable(false);
        GridData gd_combo = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_combo.widthHint = 231;
        combo.setLayoutData((Object)gd_combo);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.eval();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.eval();
            }

            public void eval() {
                switch (combo.getSelectionIndex()) {
                    case 0: {
                        NewSourceFileComposite.this.sourceFileType = SourceFileType.MAIN_DEFAULT;
                        return;
                    }
                    case 1: {
                        NewSourceFileComposite.this.sourceFileType = SourceFileType.MAIN_WITH_PARAMETERS;
                        return;
                    }
                    case 2: {
                        NewSourceFileComposite.this.sourceFileType = SourceFileType.MAIN_WEBSERVER;
                        return;
                    }
                }
            }
        });
        btnCommandSourceFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.eval();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.eval();
            }

            public void eval() {
                if (btnCommandSourceFile.getSelection()) {
                    combo.setEnabled(true);
                    switch (combo.getSelectionIndex()) {
                        case 0: {
                            NewSourceFileComposite.this.sourceFileType = SourceFileType.MAIN_DEFAULT;
                            break;
                        }
                        case 1: {
                            NewSourceFileComposite.this.sourceFileType = SourceFileType.MAIN_WITH_PARAMETERS;
                            break;
                        }
                        case 2: {
                            NewSourceFileComposite.this.sourceFileType = SourceFileType.MAIN_WEBSERVER;
                        }
                    }
                    NewSourceFileComposite.this.sourceFilename.setText(NewSourceFileComposite.this.getNewFileName(NewSourceFileComposite.this.sourceFilename.getText(), false));
                } else {
                    combo.setEnabled(false);
                }
            }
        });
        final Button btnTestSourceFile = new Button((Composite)grpSourceFileType, 16);
        btnTestSourceFile.setText("Test Source File");
        new Label((Composite)this, 0);
        btnTestSourceFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.eval();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.eval();
            }

            public void eval() {
                if (btnTestSourceFile.getSelection()) {
                    NewSourceFileComposite.this.sourceFileType = SourceFileType.TEST;
                    NewSourceFileComposite.this.sourceFilename.setText(NewSourceFileComposite.this.getNewFileName(NewSourceFileComposite.this.sourceFilename.getText(), true));
                }
            }
        });
    }

    public String getNewFileName(String currentFileName, boolean testFile) {
        if (testFile) {
            if (!currentFileName.endsWith("_test.go")) {
                return currentFileName.replace(".go", "_test.go");
            }
        } else if (currentFileName.endsWith("_test.go")) {
            return currentFileName.replace("_test.go", ".go");
        }
        return currentFileName;
    }

    protected void checkSubclass() {
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new source file location");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.sourceFolderName.setText(result[0].toString());
        }
        this.fireDialogChange();
    }

    public void addDialogChangedListener(DialogChangeListener listener) {
        if (!this.dialogChangeListeners.keySet().contains(listener)) {
            this.dialogChangeListeners.put(listener, listener);
        }
    }

    public void removeDialogChangeListener(DialogChangeListener listener) {
        this.dialogChangeListeners.remove(listener);
    }

    private void fireDialogChange() {
        for (DialogChangeListener listener : this.dialogChangeListeners.keySet()) {
            listener.dialogChanged();
        }
    }

    public SourceFileType getSourceFileType() {
        return this.sourceFileType;
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(new Point(600, 400));
        new NewSourceFileComposite((Composite)shell, 0);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Text getSourceFolderName() {
        return this.sourceFolderName;
    }

    public void setSourceFolderName(Text sourceFolderName) {
        this.sourceFolderName = sourceFolderName;
    }

    public Text getSourceFilename() {
        return this.sourceFilename;
    }

    public void setSourceFilename(Text sourceFilename) {
        this.sourceFilename = sourceFilename;
    }

    public static enum SourceFileType {
        PACKAGE_FILE,
        MAIN_DEFAULT,
        MAIN_WITH_PARAMETERS,
        MAIN_WEBSERVER,
        TEST;

    }
}

