/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.text;

import com.googlecode.goclipse.tooling.lexer.GoNumberLexingRule;
import com.googlecode.goclipse.ui.GoUIPreferenceConstants;
import melnorme.lang.ide.core.text.DefaultPredicateRule;
import melnorme.lang.ide.ui.text.AbstractLangScanner;
import melnorme.lang.ide.ui.text.coloring.TokenRegistry;
import melnorme.lang.tooling.parser.lexer.ILexingRule2;
import melnorme.lang.utils.parse.ICharacterReader;
import melnorme.utilbox.collections.ArrayList2;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class GoScanner
extends AbstractLangScanner {
    public GoScanner(TokenRegistry tokenRegistry) {
        super(tokenRegistry);
    }

    @Override
    protected void initRules(ArrayList2<IRule> rules) {
        rules.add((Object)new WhitespaceRule((IWhitespaceDetector)new AbstractLangScanner.LangWhitespaceDetector()));
        IToken tkDefault = this.getToken(GoUIPreferenceConstants.DEFAULT);
        WordRule wordRule = new WordRule((IWordDetector)new AbstractLangScanner.JavaWordDetector(), tkDefault);
        IToken keyword = this.getToken(GoUIPreferenceConstants.KEYWORD);
        IToken primitive = this.getToken(GoUIPreferenceConstants.KW_NATIVE_TYPES);
        IToken builtinFunction = this.getToken(GoUIPreferenceConstants.BUILTIN_FUNCTION);
        IToken textToken = this.getToken(GoUIPreferenceConstants.DEFAULT);
        this.setDefaultReturnToken(textToken);
        wordRule.addWord("break", keyword);
        wordRule.addWord("default", keyword);
        wordRule.addWord("func", keyword);
        wordRule.addWord("interface", keyword);
        wordRule.addWord("select", keyword);
        wordRule.addWord("case", keyword);
        wordRule.addWord("defer", keyword);
        wordRule.addWord("go", keyword);
        wordRule.addWord("map", keyword);
        wordRule.addWord("struct", keyword);
        wordRule.addWord("chan", keyword);
        wordRule.addWord("else", keyword);
        wordRule.addWord("goto", keyword);
        wordRule.addWord("package", keyword);
        wordRule.addWord("switch", keyword);
        wordRule.addWord("const", keyword);
        wordRule.addWord("fallthrough", keyword);
        wordRule.addWord("if", keyword);
        wordRule.addWord("range", keyword);
        wordRule.addWord("type", keyword);
        wordRule.addWord("continue", keyword);
        wordRule.addWord("for", keyword);
        wordRule.addWord("import", keyword);
        wordRule.addWord("return", keyword);
        wordRule.addWord("var", keyword);
        wordRule.addWord("iota", keyword);
        wordRule.addWord("append", builtinFunction);
        wordRule.addWord("cap", builtinFunction);
        wordRule.addWord("close", builtinFunction);
        wordRule.addWord("complex", builtinFunction);
        wordRule.addWord("copy", builtinFunction);
        wordRule.addWord("delete", builtinFunction);
        wordRule.addWord("imag", builtinFunction);
        wordRule.addWord("len", builtinFunction);
        wordRule.addWord("make", builtinFunction);
        wordRule.addWord("new", builtinFunction);
        wordRule.addWord("panic", builtinFunction);
        wordRule.addWord("print", builtinFunction);
        wordRule.addWord("println", builtinFunction);
        wordRule.addWord("real", builtinFunction);
        wordRule.addWord("recover", builtinFunction);
        IToken value = this.getToken(GoUIPreferenceConstants.KW_LITERAL);
        wordRule.addWord("nil", value);
        wordRule.addWord("true", value);
        wordRule.addWord("false", value);
        wordRule.addWord("uint8", primitive);
        wordRule.addWord("uint16", primitive);
        wordRule.addWord("uint32", primitive);
        wordRule.addWord("uint64", primitive);
        wordRule.addWord("int8", primitive);
        wordRule.addWord("int16", primitive);
        wordRule.addWord("int32", primitive);
        wordRule.addWord("int64", primitive);
        wordRule.addWord("float32", primitive);
        wordRule.addWord("float64", primitive);
        wordRule.addWord("complex64", primitive);
        wordRule.addWord("complex128", primitive);
        wordRule.addWord("rune", primitive);
        wordRule.addWord("byte", primitive);
        wordRule.addWord("uint", primitive);
        wordRule.addWord("int", primitive);
        wordRule.addWord("uintptr", primitive);
        wordRule.addWord("string", primitive);
        wordRule.addWord("bool", primitive);
        wordRule.addWord("error", primitive);
        rules.add((Object)wordRule);
        rules.add((Object)new AbstractLangScanner.LexingRule_RuleAdapter(this, new GoSubLexer(this.getToken(GoUIPreferenceConstants.NUMBER))));
        rules.add((Object)new GoOperatorRule(this.getToken(GoUIPreferenceConstants.OPERATOR)));
        rules.add((Object)new GoControlCharactersRule(this.getToken(GoUIPreferenceConstants.STRUCTURAL_SYMBOLS)));
    }

    public static class GoControlCharactersRule
    extends DefaultPredicateRule {
        public GoControlCharactersRule(IToken token) {
            super(token);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int read = scanner.read();
            if (read == -1) {
                return Token.UNDEFINED;
            }
            switch (read) {
                case 40: 
                case 41: 
                case 46: 
                case 58: 
                case 59: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    return this.getSuccessToken();
                }
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    public static class GoOperatorRule
    extends DefaultPredicateRule {
        public GoOperatorRule(IToken token) {
            super(token);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int read = scanner.read();
            if (read == -1) {
                return Token.UNDEFINED;
            }
            switch (read) {
                case 43: {
                    return this.currentOr('=', '+', scanner);
                }
                case 45: {
                    return this.currentOr('=', '-', scanner);
                }
                case 42: {
                    return this.currentOr('=', scanner);
                }
                case 47: {
                    return this.currentOr('=', scanner);
                }
                case 94: {
                    return this.currentOr('=', scanner);
                }
                case 33: {
                    return this.currentOr('=', scanner);
                }
                case 61: {
                    return this.currentOr('=', scanner);
                }
                case 37: {
                    return this.currentOr('=', scanner);
                }
                case 124: {
                    return this.currentOr('=', '|', scanner);
                }
                case 38: {
                    if (GoOperatorRule.consume((char)'^', (ICharacterScanner)scanner)) {
                        return this.currentOr('=', scanner);
                    }
                    return this.currentOr('=', '&', scanner);
                }
                case 60: {
                    if (GoOperatorRule.consume((char)'<', (ICharacterScanner)scanner)) {
                        return this.currentOr('=', scanner);
                    }
                    return this.currentOr('=', '-', scanner);
                }
                case 62: {
                    if (GoOperatorRule.consume((char)'>', (ICharacterScanner)scanner)) {
                        return this.currentOr('=', scanner);
                    }
                    return this.currentOr('=', scanner);
                }
                case 58: {
                    if (!GoOperatorRule.consume((char)'=', (ICharacterScanner)scanner)) break;
                    return this.getSuccessToken();
                }
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    protected final class GoSubLexer
    implements ILexingRule2<IToken> {
        protected final GoNumberLexingRule numberRule = new GoNumberLexingRule();
        protected final IToken numberToken;

        public GoSubLexer(IToken numberToken) {
            this.numberToken = numberToken;
        }

        public IToken doEvaluateToken(ICharacterReader subReader) {
            if (this.numberRule.doEvaluate(subReader)) {
                return this.numberToken;
            }
            return null;
        }
    }
}

