/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.preferences;

import com.googlecode.goclipse.core.GoToolPreferences;
import com.googlecode.goclipse.ui.editor.actions.GoFmtEditorOperation;
import com.googlecode.goclipse.ui.preferences.Start_GoInstallJob_Operation;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ToolchainPreferences;
import melnorme.lang.ide.ui.preferences.AbstractToolLocationGroup;
import melnorme.lang.ide.ui.preferences.common.PreferencesPageContext;
import melnorme.lang.ide.ui.preferences.pages.DownloadToolTextField;
import melnorme.lang.ide.ui.preferences.pages.LanguageToolsBlock;
import melnorme.lang.ide.ui.utils.ControlUtils;
import melnorme.lang.ide.ui.utils.operations.BasicUIOperation;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.IDisableableWidget;
import melnorme.util.swt.components.fields.ButtonTextField;
import melnorme.util.swt.components.fields.CheckBoxField;
import melnorme.util.swt.components.fields.EnablementButtonTextField2;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import org.eclipse.swt.widgets.Composite;

public class GoToolsConfigBlock
extends LanguageToolsBlock {
    public GoToolsConfigBlock(PreferencesPageContext prefContext) {
        super(prefContext);
        this.addChildWidget(new GoGuruGroup());
        this.addChildWidget(new GoDefGroup());
        this.addChildWidget(new GoFmtGroup());
    }

    @Override
    protected LanguageToolsBlock.EngineToolGroup init_createEngineToolGroup() {
        return new LanguageToolsBlock.EngineToolGroup(this){

            @Override
            protected ButtonTextField initToolLocationField() {
                return new DownloadToolTextField(){

                    @Override
                    protected BasicUIOperation getDownloadButtonHandler() {
                        return new Start_GoInstallJob_Operation("Download gocode", "Downloading gocode...", this, "github.com/nsf/gocode", "gocode"){};
                    }
                };
            }
        };
    }

    @Override
    protected void createContents(Composite topControl) {
        SWTFactoryUtil.createLabel(topControl, 0, "Note: if you've made any changes in the Go SDK preferences, \nmake sure you press \"Apply\" in that page before using the `Download...` button.", this.createSubComponentDefaultGridData());
        super.createContents(topControl);
    }

    public class GoDefGroup
    extends AbstractToolLocationGroup {
        public GoDefGroup() {
            super("godef");
            GoToolsConfigBlock.this.bindFieldToDerivedPreference(this.toolLocationField, GoToolPreferences.GODEF_Path);
        }

        @Override
        protected BasicUIOperation do_getDownloadButtonHandler(DownloadToolTextField toolLocationField) {
            return new Start_GoInstallJob_Operation("Download godef", "Downloading godef...", toolLocationField, "github.com/rogpeppe/godef", "godef"){};
        }
    }

    public class GoFmtGroup
    extends EnablementButtonTextField2 {
        protected final CheckBoxField formatOnSaveField;

        public GoFmtGroup() {
            super("gofmt:", "Use default location (from Go installation).");
            GoToolsConfigBlock.this.prefContext.bindToPreference(this.asEffectiveValueProperty(), GoToolPreferences.GOFMT_Path.getPreference());
            this.buttonTextField.addFieldValidator(true, GoToolPreferences.GOFMT_Path.getValidator());
            this.formatOnSaveField = new CheckBoxField("Format automatically on editor save.");
            this.addChildWidget(this.formatOnSaveField);
            GoToolsConfigBlock.this.prefContext.bindToPreference(this.formatOnSaveField, ToolchainPreferences.FORMAT_ON_SAVE);
        }

        @Override
        protected ButtonTextField init_createButtonTextField() {
            return new ButtonTextField("Executable:", "B&rowse..."){

                @Override
                protected String getNewValueFromButtonSelection() throws OperationCancellation {
                    return ControlUtils.openFileDialog((String)this.getFieldValue(), this.button.getShell());
                }
            };
        }

        @Override
        protected String getDefaultFieldValue() throws CommonException {
            Location rootLoc = Location.create((String)((String)LangCore.settings().SDK_LOCATION.getGlobalPreference().get()));
            return GoFmtEditorOperation.getGofmtLocationFromGoRoot(rootLoc).toPathString();
        }

        @Override
        protected void updateChildrenEnablement() {
            for (IDisableableWidget childWidget : this.getChildWidgets()) {
                if (childWidget == this.enablementField || childWidget == this.formatOnSaveField) continue;
                childWidget.setEnabled(!this.isUseDefault());
            }
        }
    }

    public class GoGuruGroup
    extends AbstractToolLocationGroup {
        public GoGuruGroup() {
            super("guru");
            GoToolsConfigBlock.this.bindFieldToDerivedPreference(this.toolLocationField, GoToolPreferences.GO_GURU_Path);
        }

        @Override
        protected BasicUIOperation do_getDownloadButtonHandler(DownloadToolTextField toolLocationField) {
            return new Start_GoInstallJob_Operation("Download guru", "Downloading guru...", toolLocationField, "golang.org/x/tools/cmd/guru", "guru"){};
        }
    }
}

