/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.navigator;

import com.googlecode.goclipse.core.GoProjectEnvironment;
import com.googlecode.goclipse.tooling.env.GoPath;
import com.googlecode.goclipse.tooling.env.GoWorkspaceLocation;
import com.googlecode.goclipse.ui.GoPluginImages;
import com.googlecode.goclipse.ui.navigator.elements.GoPathElement;
import com.googlecode.goclipse.ui.navigator.elements.GoPathEntryElement;
import com.googlecode.goclipse.ui.navigator.elements.GoRootElement;
import java.nio.file.Path;
import melnorme.lang.ide.core.project_model.view.IBundleModelElement;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.navigator.LangNavigatorLabelProvider;
import melnorme.lang.ide.ui.views.StylerHelpers;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class GoNavigatorLabelProvider
extends LangNavigatorLabelProvider {
    protected static final RGB LOCATION_ANNOTATION_FG = new RGB(128, 128, 128);

    @Override
    protected LangNavigatorLabelProvider.DefaultGetStyledStringSwitcher getStyledString_switcher() {
        return new LangNavigatorLabelProvider.DefaultGetStyledStringSwitcher(){

            @Override
            public StyledString visitGoPathElement(GoPathElement goPathElement) {
                return GoNavigatorLabelProvider.this.getStyledText_GoPathElement(goPathElement);
            }

            @Override
            public StyledString visitFileStoreElement(IFileStore fileStore) {
                return new StyledString(fileStore.getName());
            }

            @Override
            public StyledString visitBundleElement(IBundleModelElement bundleElement) {
                return (StyledString)new LangNavigatorLabelProvider.BundleModelGetStyledStringSwitcher(GoNavigatorLabelProvider.this){}.switchBundleElement(bundleElement);
            }
        };
    }

    public StyledString getStyledText_GoPathElement(GoPathElement goPathElement) {
        StyledString baseText = new StyledString(goPathElement.getName());
        if (goPathElement instanceof GoRootElement) {
            GoRootElement goRootElement = (GoRootElement)goPathElement;
            baseText.append(" - " + goRootElement.getDirectory().toString(), (StyledString.Styler)StylerHelpers.fgColor(LOCATION_ANNOTATION_FG));
            return baseText;
        }
        if (goPathElement instanceof GoPathEntryElement) {
            GoPathEntryElement goPathEntryElement = (GoPathEntryElement)goPathElement;
            baseText.append(" - ", (StyledString.Styler)StylerHelpers.fgColor(LOCATION_ANNOTATION_FG));
            String goPathEntryLocation = goPathEntryElement.getDirectory().toString();
            StyledString suffix = goPathEntryElement.isProjectInsideThisGoPathEntry() ? new StyledString(goPathEntryLocation, (StyledString.Styler)new StylerHelpers.ItalicStyler(StylerHelpers.fgColor(LOCATION_ANNOTATION_FG))) : new StyledString(goPathEntryLocation, (StyledString.Styler)StylerHelpers.fgColor(LOCATION_ANNOTATION_FG));
            baseText.append(suffix);
            return baseText;
        }
        throw Assert.AssertNamespace.assertFail();
    }

    @Override
    protected LangNavigatorLabelProvider.DefaultGetImageSwitcher getBaseImage_switcher() {
        return new LangNavigatorLabelProvider.DefaultGetImageSwitcher(){

            @Override
            public ImageDescriptor visitResource(IResource resource) {
                return GoNavigatorLabelProvider.this.getResourceImageDescriptor(resource);
            }

            @Override
            public ImageDescriptor visitGoPathElement(GoPathElement goPathElement) {
                if (goPathElement instanceof GoRootElement) {
                    return GoPluginImages.NAV_LibraryNative;
                }
                if (goPathElement instanceof GoPathEntryElement) {
                    return GoPluginImages.NAVIGATOR_GOPATH_ENTRY.getDescriptor();
                }
                throw Assert.AssertNamespace.assertFail();
            }

            @Override
            public ImageDescriptor visitFileStoreElement(IFileStore fileStore) {
                try {
                    if (fileStore.fetchInfo().isDirectory()) {
                        return GoPluginImages.NAV_SourceFolder;
                    }
                    IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)fileStore.getName(), (boolean)true, (boolean)false);
                    if (descriptor != null) {
                        return descriptor.getImageDescriptor();
                    }
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    return workbench.getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
                }
                catch (PartInitException partInitException) {
                    return null;
                }
            }

            @Override
            public ImageDescriptor visitBundleElement(IBundleModelElement bundleElement) {
                return (ImageDescriptor)new LangNavigatorLabelProvider.BundleModelGetImageSwitcher(){}.switchBundleElement(bundleElement);
            }
        };
    }

    protected ImageDescriptor getResourceImageDescriptor(IResource resource) {
        IFile file;
        Location resourceLocation;
        Location projectLocation;
        IProject project = resource.getProject();
        try {
            projectLocation = ResourceUtils.getLocation((IResource)project);
            resourceLocation = ResourceUtils.getLocation((IResource)resource);
        }
        catch (CommonException e) {
            return null;
        }
        if (resource instanceof IFolder) {
            GoPath goPath = GoProjectEnvironment.getEffectiveGoPath((IProject)project);
            GoWorkspaceLocation goWorkspaceRoot = goPath.findGoPathEntry(resourceLocation);
            if (goWorkspaceRoot == null) {
                return null;
            }
            boolean isProjectAGoWorkspace = goWorkspaceRoot.getLocation().equals((Object)projectLocation);
            if (isProjectAGoWorkspace && resource.getParent() == project) {
                if ("src".equals(resource.getName())) {
                    return GoPluginImages.NAV_SourceFolder;
                }
                if ("pkg".equals(resource.getName())) {
                    return GoPluginImages.NAVIGATOR_PKG_FOLDER.getDescriptor();
                }
                if ("bin".equals(resource.getName())) {
                    return GoPluginImages.NAV_OutputFolder;
                }
            } else if (resourceLocation.startsWith(goWorkspaceRoot.getSrcLocation())) {
                return GoPluginImages.NAV_SourceFolder;
            }
        } else if (resource instanceof IFile && CoreUtil.areEqual((Object)"a", (Object)(file = (IFile)resource).getFileExtension())) {
            return GoPluginImages.NAVIGATOR_GO_PACKAGE_FILE.getDescriptor();
        }
        return null;
    }

    protected static boolean isSourcePackageFolder(IFolder folder, boolean isProjecInsideGoPath) {
        Path path = folder.getProjectRelativePath().toFile().toPath();
        if (isProjecInsideGoPath) {
            return GoNavigatorLabelProvider.isValidSourcePackageName(path);
        }
        if (path.startsWith("src")) {
            path = MiscUtil.createValidPath((String)"src").relativize(path);
            return GoNavigatorLabelProvider.isValidSourcePackageName(path);
        }
        return false;
    }

    protected static boolean isValidSourcePackageName(Path path) {
        return true;
    }
}

