/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.launch;

import com.googlecode.goclipse.core.GoProjectEnvironment;
import com.googlecode.goclipse.core.operations.GoBuildManager;
import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import melnorme.lang.ide.core.launch.BuildTargetLaunchCreator;
import melnorme.lang.ide.core.launch.ProjectLaunchSettings;
import melnorme.lang.ide.ui.build.BuildTargetEditor;
import melnorme.lang.ide.ui.launch.MainLaunchConfigurationTab;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.tooling.bundle.BuildTargetNameParser;
import melnorme.util.swt.components.fields.ButtonTextField;
import melnorme.util.swt.components.fields.ComboOptionsField;
import melnorme.util.swt.components.fields.EnablementButtonTextField;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class GoMainLaunchConfigurationTab
extends MainLaunchConfigurationTab {
    protected final ButtonTextField goPackageField = this.init_createGoPackageField();
    protected final ComboOptionsField buildTypeField = this.init_createBuildTypeField();

    public GoMainLaunchConfigurationTab() {
        super(false);
        ArrayList2 fieldOptions = GoBuildManager.BUILD_TYPES_Names.toArrayList();
        fieldOptions.remove((Object)"[run-tests]");
        this.buildTypeField.setFieldOptions((Indexable<String>)fieldOptions);
        this.initBindings();
    }

    protected ButtonTextField init_createGoPackageField() {
        return new GoPackageField("Go package to build:", null, "Select...");
    }

    protected ComboOptionsField init_createBuildTypeField() {
        return new ComboOptionsField("Build type:");
    }

    @Override
    protected BuildTargetEditor init_BuildTargetSettingsComponent() {
        BuildTargetEditor component = super.init_BuildTargetSettingsComponent();
        component.buildCommandField.getEnablementField().setLabelText("Use default:");
        component.programPathField.getUseDefaultField().setLabelText("Use default:");
        return component;
    }

    @Override
    protected String getBuildTargetName() {
        String buildType = (String)this.buildTypeField.getFieldValue();
        return this.getBuildTargetNameParser().getFullName((String)this.goPackageField.getFieldValue(), buildType);
    }

    protected BuildTargetNameParser getBuildTargetNameParser() {
        return this.getBuildManager().getBuildTargetNameParser();
    }

    @Override
    protected void initBindings() {
        super.initBindings();
        this.goPackageField.addChangeListener(this::buildTargetFieldChanged);
        this.buildTypeField.addChangeListener(this::buildTargetFieldChanged);
    }

    @Override
    protected void createCustomControls(Composite parent) {
        this.goPackageField.createComponent(parent, new GridData(768));
        this.buildTargetEditor.createComponent(parent, new GridData(1808));
    }

    protected String openProgramPathDialog(IProject project) throws OperationCancellation {
        try {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    GoPackageName goPackageName = (GoPackageName)element;
                    return goPackageName.getFullNameAsString();
                }
            });
            dialog.setTitle("Select Go main package");
            dialog.setMessage("Select Go main package");
            GoEnvironment goEnv = GoProjectEnvironment.getGoEnvironment((IProject)project);
            ArrayList2 sourcePackages = GoProjectEnvironment.findSourcePackages((IProject)project, (GoEnvironment)goEnv);
            dialog.setElements(sourcePackages.toArray());
            if (dialog.open() == 0) {
                GoPackageName goPackageName = (GoPackageName)dialog.getFirstResult();
                return goPackageName.getFullNameAsString();
            }
        }
        catch (CommonException ce) {
            UIOperationsStatusHandler.handleStatus(false, "Error selecting package from dialog: ", ce);
        }
        throw new OperationCancellation();
    }

    @Override
    protected ProjectLaunchSettings getDefaultProjectLaunchSettings() {
        return new BuildTargetLaunchCreator(){

            public ProjectLaunchSettings initFrom(IResource contextualResource) {
                ProjectLaunchSettings initFrom = super.initFrom(contextualResource);
                this.data.targetName = "";
                return initFrom;
            }
        };
    }

    @Override
    protected void initializeBuildTargetField(BuildTargetLaunchCreator btLaunchCreator) {
        String buildTargetName = btLaunchCreator.data.targetName;
        String buildConfiguration = this.getBuildTargetNameParser().getBuildConfigName(buildTargetName);
        String buildTypeName = this.getBuildTargetNameParser().getBuildTypeName(buildTargetName);
        this.goPackageField.setFieldValue(buildConfiguration);
        this.buildTypeField.setFieldValue(buildTypeName);
        if (this.buildTypeField.getFieldValue() == null) {
            this.buildTypeField.setFieldValue((String)this.buildTypeField.getComboOptions().get(0));
        }
    }

    protected class GoPackageField
    extends EnablementButtonTextField {
        public GoPackageField(String labelText, String useDefaultField_Label, String buttonlabel) {
            super(labelText, useDefaultField_Label, buttonlabel);
        }

        @Override
        protected String getDefaultFieldValue() throws CommonException {
            return null;
        }

        @Override
        protected void createContents_all(Composite topControl) {
            super.createContents_all(topControl);
            GoMainLaunchConfigurationTab.this.buildTypeField.createComponent(topControl, new GridData(768));
        }

        @Override
        protected String getNewValueFromButtonSelection() throws StatusException, OperationCancellation {
            return GoMainLaunchConfigurationTab.this.openProgramPathDialog(GoMainLaunchConfigurationTab.this.getValidProject());
        }
    }
}

