/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.launch;

import com.googlecode.goclipse.core.GoProjectEnvironment;
import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.launch.BuildTargetLaunchCreator;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.ui.launch.BaseLaunchShortcut;
import melnorme.lang.ide.ui.launch.LangLaunchShortcut;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.ui.ILaunchShortcut;

public class GoLaunchShortcut
extends LangLaunchShortcut
implements ILaunchShortcut {
    public final BuildManager buildManager = LangCore.getBuildManager();
    public static final String LAUNCH_CONFIG_ID = "com.googlecode.goclipse.launch.goLaunchType";

    @Override
    protected String getLaunchTypeId() {
        return LAUNCH_CONFIG_ID;
    }

    @Override
    protected BaseLaunchShortcut.ILaunchable getLaunchTargetForElement(Object element, IOperationMonitor om) throws CommonException, OperationCancellation {
        IResource resource = element instanceof IResource ? (IResource)element : (IResource)EclipseUtils.getAdapter((Object)element, IResource.class);
        if (resource instanceof IFile) {
            return this.getLaunchableForGoPackage((IResource)resource.getParent());
        }
        if (resource instanceof IFolder) {
            return this.getLaunchableForGoPackage(resource);
        }
        return null;
    }

    protected BaseLaunchShortcut.ILaunchable getLaunchableForGoPackage(IResource goPackageResource) throws CommonException {
        Location goPackageLocation;
        IProject project = goPackageResource.getProject();
        if (project == null) {
            return null;
        }
        GoEnvironment goEnv = GoProjectEnvironment.getGoEnvironment((IProject)project);
        GoPackageName goPackageName = goEnv.findGoPackageForLocation(goPackageLocation = ResourceUtils.getResourceLocation((IResource)goPackageResource));
        if (goPackageName == null) {
            throw CommonException.fromMsgFormat((String)"{0}", (Object[])new Object[]{"Resource doesn't have a corresponding Go package."});
        }
        BuildTargetLaunchCreator btLaunchCreator = new BuildTargetLaunchCreator().initFromProject(project);
        btLaunchCreator.data.targetName = this.buildManager.getBuildTargetName2(goPackageName.asString(), "build");
        return new LangLaunchShortcut.BuildTargetLaunchable(this, project, btLaunchCreator);
    }
}

