/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.ui.editor.actions;

import com.googlecode.goclipse.core.GoProjectEnvironment;
import com.googlecode.goclipse.core.GoToolPreferences;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import java.nio.file.Path;
import melnorme.lang.ide.ui.editor.actions.AbstractEditorToolOperation;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;

public class GoFmtEditorOperation
extends AbstractEditorToolOperation<String> {
    protected static final String RUN_GOFMT_OpName = "Run 'gofmt'";
    protected ProcessBuilder pb;

    public GoFmtEditorOperation(ITextEditor editor) {
        super(RUN_GOFMT_OpName, editor);
    }

    @Override
    public void prepareOperation() throws CommonException {
        super.prepareOperation();
        GoEnvironment goEnv = GoProjectEnvironment.getGoEnvironment((IProject)this.project);
        this.pb = this.prepareProcessBuilder(goEnv);
    }

    protected ProcessBuilder prepareProcessBuilder(GoEnvironment goEnv) throws CommonException {
        Path gofmt = this.getGofmtLocation(goEnv);
        Indexable cmd = CoreUtil.list((Object[])new String[]{gofmt.toString()});
        return goEnv.createProcessBuilder(cmd, null, true);
    }

    protected Path getGofmtLocation(GoEnvironment goEnv) throws CommonException {
        if (GoToolPreferences.GOFMT_Path.getPreference().get() == null) {
            return GoFmtEditorOperation.getGofmtLocationFromGoRoot(goEnv.getGoRoot_Location()).toPath();
        }
        return (Path)GoToolPreferences.GOFMT_Path.getDerivedValue();
    }

    public static Location getGofmtLocationFromGoRoot(Location rootLocation) throws CommonException {
        return rootLocation.resolve_fromValid("bin/gofmt" + MiscUtil.getExecutableSuffix());
    }

    @Override
    protected String doBackgroundToolResultComputation(IOperationMonitor om) throws CommonException, OperationCancellation, OperationSoftFailure {
        ExternalProcessHelper.ExternalProcessResult processResult = this.getToolService().runProcess(this.pb, this.getSource(), (ICancelMonitor)om);
        int exitValue = processResult.exitValue;
        if (exitValue != 0) {
            throw new OperationSoftFailure("`gofmt` did not complete successfully, exit code: " + exitValue + "\n" + processResult.getStdErrBytes().toString());
        }
        return processResult.getStdOutBytes().toString();
    }

    @Override
    protected void handleResultData(String resultData) throws CommonException {
        Assert.AssertNamespace.assertNotNull((Object)resultData);
        this.setEditorTextPreservingCarret(resultData);
    }
}

