/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GoSearchPage
extends DialogPage
implements ISearchPage {
    private static final int HISTORY_SIZE = 12;
    public static final String EXTENSION_POINT_ID = "org.googlecode.goclipse.searchPage";
    private static final String PAGE_NAME = "GoSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_IS_REG_EX_SEARCH = "REG_EX_SEARCH";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private List<SearchPatternData> fPreviousSearchPatterns = new ArrayList<SearchPatternData>(12);
    private boolean fFirstTime = true;
    private boolean fIsCaseSensitive;
    private boolean fIsRegExSearch;
    private Combo fPattern;
    private Button fIsCaseSensitiveCheckbox;
    private Button fIsRegExCheckbox;
    private CLabel fStatusLabel;
    private ISearchPageContainer fContainer;
    private ContentAssistCommandAdapter fPatterFieldContentAssist;

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        this.addTextPatternControls(result);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    public FileTextSearchScope createTextSearchScope() {
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)false);
            }
            case 1: {
                return this.getSelectedResourcesScope();
            }
            case 3: {
                return this.getEnclosingProjectScope();
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                return FileTextSearchScope.newSearchScope((IWorkingSet[])workingSets, (String[])this.getExtensions(), (boolean)false);
            }
        }
        return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)false);
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    public boolean performAction() {
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)this.newQuery());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Search", (String)"Problems occurred while searching. The affected files will be skipped.", (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                if (!this.initializePatternControl()) {
                    this.fPattern.select(0);
                    this.handleWidgetSelected();
                }
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    private IEditorInput getActiveEditorInput() {
        IEditorPart editor = this.getActiveEditor();
        if (editor == null) {
            return null;
        }
        if (editor instanceof MultiPageEditorPart) {
            Object page = ((MultiPageEditorPart)editor).getSelectedPage();
            if (page instanceof IEditorPart) {
                editor = (IEditorPart)page;
            } else {
                return null;
            }
        }
        return editor.getEditorInput();
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPart activePart;
        IEditorPart activeEditor;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && ((activeEditor = activePage.getActiveEditor()) == (activePart = activePage.getActivePart()) || GoSearchPage.isOldSearchView(activePart))) {
            return activeEditor;
        }
        return null;
    }

    private static boolean isOldSearchView(IWorkbenchPart part) {
        return "org.eclipse.search.SearchResultView".equals(part.getSite().getId());
    }

    final void updateOKStatus() {
        boolean regexStatus = this.validateRegex();
        this.getContainer().setPerformActionEnabled(regexStatus);
    }

    private void addTextPatternControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText("Containing &text:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fPattern = new Combo(group, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoSearchPage.this.handleWidgetSelected();
                GoSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GoSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.fPatterFieldContentAssist = new ContentAssistCommandAdapter((Control)this.fPattern, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        this.fPatterFieldContentAssist.setEnabled(this.fIsRegExSearch);
        this.fIsCaseSensitiveCheckbox = new Button(group, 32);
        this.fIsCaseSensitiveCheckbox.setText("&Case sensitive");
        this.fIsCaseSensitiveCheckbox.setSelection(this.fIsCaseSensitive);
        this.fIsCaseSensitiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoSearchPage.this.fIsCaseSensitive = GoSearchPage.this.fIsCaseSensitiveCheckbox.getSelection();
            }
        });
        this.fIsCaseSensitiveCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsCaseSensitiveCheckbox.setFont(group.getFont());
        this.fStatusLabel = new CLabel(group, 16384);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fStatusLabel.setFont(group.getFont());
        this.fStatusLabel.setAlignment(16384);
        this.fStatusLabel.setText("(* = any string, ? = any character, \\ = escape for literals: * ? \\)");
        this.fIsRegExCheckbox = new Button(group, 32);
        this.fIsRegExCheckbox.setText("Regular e&xpression");
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.fIsRegExCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoSearchPage.this.fIsRegExSearch = GoSearchPage.this.fIsRegExCheckbox.getSelection();
                GoSearchPage.this.updateOKStatus();
                GoSearchPage.this.writeConfiguration();
                GoSearchPage.this.fPatterFieldContentAssist.setEnabled(GoSearchPage.this.fIsRegExSearch);
            }
        });
        this.fIsRegExCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsRegExCheckbox.setFont(group.getFont());
    }

    private SearchPatternData findInPrevious(String pattern) {
        for (SearchPatternData element : this.fPreviousSearchPatterns) {
            if (!pattern.equals(element.textPattern)) continue;
            return element;
        }
        return null;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IDialogSettings getDialogSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection(PAGE_NAME);
    }

    private FileTextSearchScope getEnclosingProjectScope() {
        String[] enclosingProjectName = this.getContainer().getSelectedProjectNames();
        if (enclosingProjectName == null) {
            return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)false);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        int i = 0;
        while (i < res.length) {
            res[i] = root.getProject(enclosingProjectName[i]);
            ++i;
        }
        return FileTextSearchScope.newSearchScope((IResource[])res, (String[])this.getExtensions(), (boolean)false);
    }

    private String[] getExtensions() {
        return new String[]{"*.go"};
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData getPatternData() {
        SearchPatternData match = this.findInPrevious(this.fPattern.getText());
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getPattern(), this.isCaseSensitive(), this.fIsRegExCheckbox.getSelection(), this.getExtensions(), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    private String[] getPreviousSearchPatterns() {
        int size = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = this.fPreviousSearchPatterns.get((int)i).textPattern;
            ++i;
        }
        return patterns;
    }

    private FileTextSearchScope getSelectedResourcesScope() {
        HashSet<Object> resources = new HashSet<Object>();
        ISelection sel = this.getContainer().getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            for (Object curr : (IStructuredSelection)sel) {
                IResource resource;
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)false);
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2 = (IResource)elements[i].getAdapter(IResource.class);
                        if (resource2 != null && resource2.isAccessible()) {
                            resources.add(resource2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (curr instanceof LineElement) {
                    resource = ((LineElement)curr).getParent();
                    if (resource == null || !resource.isAccessible()) continue;
                    resources.add(resource);
                    continue;
                }
                if (!(curr instanceof IAdaptable) || (resource = (IResource)((IAdaptable)curr).getAdapter(IResource.class)) == null || !resource.isAccessible()) continue;
                resources.add(resource);
            }
        } else if (this.getActiveEditorInput() != null) {
            resources.add((IFile)this.getActiveEditorInput().getAdapter(IFile.class));
        }
        IResource[] arr = resources.toArray(new IResource[resources.size()]);
        return FileTextSearchScope.newSearchScope((IResource[])arr, (String[])this.getExtensions(), (boolean)false);
    }

    private ISelection getSelection() {
        return this.fContainer.getSelection();
    }

    private void handleWidgetSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData patternData = this.fPreviousSearchPatterns.get(selectionIndex);
        if (!this.fPattern.getText().equals(patternData.textPattern)) {
            return;
        }
        this.fIsCaseSensitiveCheckbox.setSelection(patternData.isCaseSensitive);
        this.fIsRegExSearch = patternData.isRegExSearch;
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.fPattern.setText(patternData.textPattern);
        this.fPatterFieldContentAssist.setEnabled(this.fIsRegExSearch);
        if (patternData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(patternData.workingSets);
        } else {
            this.getContainer().setSelectedScope(patternData.scope);
        }
    }

    private boolean initializePatternControl() {
        String text;
        ISelection selection = this.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && ((ITextSelection)selection).getLength() > 0 && (text = ((ITextSelection)selection).getText()) != null) {
            if (this.fIsRegExSearch) {
                this.fPattern.setText(FindReplaceDocumentAdapter.escapeForRegExPattern((String)text));
            } else {
                this.fPattern.setText(this.insertEscapeChars(text));
            }
            return true;
        }
        return false;
    }

    private String insertEscapeChars(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        StringBuffer sbIn = new StringBuffer(text);
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int lengthOfFirstLine = 0;
        try {
            lengthOfFirstLine = reader.readLine().length();
        }
        catch (IOException ex) {
            return "";
        }
        StringBuffer sbOut = new StringBuffer(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = sbIn.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append("\\");
            }
            sbOut.append(ch);
            ++i;
        }
        return sbOut.toString();
    }

    private boolean isCaseSensitive() {
        return this.fIsCaseSensitiveCheckbox.getSelection();
    }

    private ISearchQuery newQuery() throws CoreException {
        SearchPatternData data = this.getPatternData();
        TextSearchPageInput input = new TextSearchPageInput(data.textPattern, data.isCaseSensitive, data.isRegExSearch, this.createTextSearchScope());
        return TextSearchQueryProvider.getPreferred().createQuery((TextSearchQueryProvider.TextSearchInput)input);
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        this.fIsRegExSearch = s.getBoolean(STORE_IS_REG_EX_SEARCH);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        if (this.fIsRegExCheckbox.getSelection()) {
            block5: {
                try {
                    PatternConstructor.createPattern((String)this.fPattern.getText(), (boolean)this.fIsCaseSensitive, (boolean)true);
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.statusMessage(true, locMessage.substring(0, i));
                return false;
            }
            this.statusMessage(false, "");
        } else {
            this.statusMessage(false, "(* = any string, ? = any character, \\ = escape for literals: * ? \\)");
        }
        return true;
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        s.put(STORE_IS_REG_EX_SEARCH, this.fIsRegExSearch);
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private static class SearchPatternData {
        public final boolean isCaseSensitive;
        public final boolean isRegExSearch;
        public final String textPattern;
        public final String[] fileNamePatterns;
        public final int scope;
        public final IWorkingSet[] workingSets;

        public static SearchPatternData create(IDialogSettings settings) {
            String[] fileNamePatterns;
            String textPattern = settings.get("textPattern");
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            if ((fileNamePatterns = settings.getArray("fileNamePatterns")) == null) {
                fileNamePatterns = new String[]{};
            }
            try {
                int scope = settings.getInt("scope");
                boolean isRegExSearch = settings.getBoolean("isRegExSearch");
                boolean ignoreCase = settings.getBoolean("ignoreCase");
                return new SearchPatternData(textPattern, !ignoreCase, isRegExSearch, fileNamePatterns, scope, workingSets);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public SearchPatternData(String textPattern, boolean isCaseSensitive, boolean isRegExSearch, String[] fileNamePatterns, int scope, IWorkingSet[] workingSets) {
            Assert.isNotNull((Object)fileNamePatterns);
            this.isCaseSensitive = isCaseSensitive;
            this.isRegExSearch = isRegExSearch;
            this.textPattern = textPattern;
            this.fileNamePatterns = fileNamePatterns;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public void store(IDialogSettings settings) {
            settings.put("ignoreCase", !this.isCaseSensitive);
            settings.put("isRegExSearch", this.isRegExSearch);
            settings.put("textPattern", this.textPattern);
            settings.put("fileNamePatterns", this.fileNamePatterns);
            settings.put("scope", this.scope);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getLabel();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }
    }

    private static class TextSearchPageInput
    extends TextSearchQueryProvider.TextSearchInput {
        private final String fSearchText;
        private final boolean fIsCaseSensitive;
        private final boolean fIsRegEx;
        private final FileTextSearchScope fScope;

        public TextSearchPageInput(String searchText, boolean isCaseSensitive, boolean isRegEx, FileTextSearchScope scope) {
            this.fSearchText = searchText;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fIsRegEx = isRegEx;
            this.fScope = scope;
        }

        public FileTextSearchScope getScope() {
            return this.fScope;
        }

        public String getSearchText() {
            return this.fSearchText;
        }

        public boolean isCaseSensitiveSearch() {
            return this.fIsCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.fIsRegEx;
        }
    }
}

