/*
 * Decompiled with CFR 0.152.
 */
package _org.eclipse.jdt.internal.ui.viewsupport;

import _org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import java.util.HashSet;
import java.util.Set;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.utils.ResourceUtils;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ProblemMarkerManager
implements IResourceChangeListener,
IAnnotationModelListener,
IAnnotationModelListenerExtension {
    private ListenerList<IProblemChangedListener> fListeners = new ListenerList();
    private Set<IResource> fResourcesWithMarkerChanges = new HashSet<IResource>();
    private Set<IResource> fResourcesWithAnnotationChanges = new HashSet<IResource>();
    private UIJob fNotifierJob;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        HashSet<IResource> changedElements = new HashSet<IResource>();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)new ProjectErrorVisitor(changedElements));
            }
        }
        catch (CoreException e) {
            EclipseCore.logStatus((CoreException)e);
        }
        if (!changedElements.isEmpty()) {
            boolean hasChanges = false;
            ProblemMarkerManager problemMarkerManager = this;
            synchronized (problemMarkerManager) {
                if (this.fResourcesWithMarkerChanges.isEmpty()) {
                    this.fResourcesWithMarkerChanges = changedElements;
                    hasChanges = true;
                } else {
                    hasChanges = this.fResourcesWithMarkerChanges.addAll(changedElements);
                }
            }
            if (hasChanges) {
                this.fireChanges();
            }
        }
    }

    public void modelChanged(IAnnotationModel model) {
    }

    public void modelChanged(AnnotationModelEvent event) {
    }

    public void addListener(IProblemChangedListener listener) {
        if (this.fListeners.isEmpty()) {
            ResourceUtils.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IProblemChangedListener listener) {
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty()) {
            ResourceUtils.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    private void fireChanges() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            this.postAsyncUpdate(display);
        }
    }

    private void postAsyncUpdate(Display display) {
        if (this.fNotifierJob == null) {
            this.fNotifierJob = new UIJob(display, "Sending problem marker updates..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ProblemMarkerManager.this.runPendingUpdates();
                    return Status.OK_STATUS;
                }
            };
            this.fNotifierJob.setSystem(true);
        }
        this.fNotifierJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingUpdates() {
        IResource[] markerResources = null;
        IResource[] annotationResources = null;
        ProblemMarkerManager problemMarkerManager = this;
        synchronized (problemMarkerManager) {
            if (!this.fResourcesWithMarkerChanges.isEmpty()) {
                markerResources = this.fResourcesWithMarkerChanges.toArray(new IResource[this.fResourcesWithMarkerChanges.size()]);
                this.fResourcesWithMarkerChanges.clear();
            }
            if (!this.fResourcesWithAnnotationChanges.isEmpty()) {
                annotationResources = this.fResourcesWithAnnotationChanges.toArray(new IResource[this.fResourcesWithAnnotationChanges.size()]);
                this.fResourcesWithAnnotationChanges.clear();
            }
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IProblemChangedListener curr = (IProblemChangedListener)listeners[i];
            if (markerResources != null) {
                curr.problemsChanged(markerResources, true, true);
            }
            if (annotationResources != null) {
                curr.problemsChanged(annotationResources, false, true);
            }
            ++i;
        }
    }

    private static class ProjectErrorVisitor
    implements IResourceDeltaVisitor {
        private HashSet<IResource> fChangedElements;

        public ProjectErrorVisitor(HashSet<IResource> changedElements) {
            this.fChangedElements = changedElements;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IProject project;
            IResource res = delta.getResource();
            if (res instanceof IProject && delta.getKind() == 4 && !(project = (IProject)res).isAccessible()) {
                return false;
            }
            this.checkInvalidate(delta, res);
            return true;
        }

        private void checkInvalidate(IResourceDelta delta, IResource resource) {
            int kind = delta.getKind();
            if (kind == 2 || kind == 1 || kind == 4 && this.isErrorDelta(delta)) {
                while (resource.getType() != 8 && this.fChangedElements.add(resource)) {
                    resource = resource.getParent();
                }
            }
        }

        protected boolean isErrorDelta(IResourceDelta delta) {
            if ((delta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
                int i = 0;
                while (i < markerDeltas.length) {
                    if (markerDeltas[i].isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        int kind = markerDeltas[i].getKind();
                        if (kind == 1 || kind == 2) {
                            return true;
                        }
                        int severity = markerDeltas[i].getAttribute("severity", -1);
                        int newSeverity = markerDeltas[i].getMarker().getAttribute("severity", -1);
                        if (newSeverity != severity) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

