/*
 * Decompiled with CFR 0.152.
 */
package _org.eclipse.jdt.internal.ui.text.java.hover;

import _org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import _org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import java.util.Iterator;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.tooling.common.ISourceBuffer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public abstract class AbstractAnnotationHover
extends AbstractJavaEditorTextHover {
    private final IPreferenceStore fStore = LangUIPlugin.getDefault().getCombinedPreferenceStore();
    private final DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    private final boolean fAllAnnotations;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public AbstractAnnotationHover(boolean allAnnotations) {
        this.fAllAnnotations = allAnnotations;
    }

    @Override
    public Object getHoverInfo(ISourceBuffer sourceBuffer, IRegion hoverRegion, ITextViewer textViewer) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        ISourceViewer sourceViewer = (ISourceViewer)textViewer;
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        Iterator parent = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(hoverRegion.getOffset(), hoverRegion.getLength(), true, true) : model.getAnnotationIterator();
        JavaAnnotationIterator e = new JavaAnnotationIterator(parent, this.fAllAnnotations);
        int layer = -1;
        Annotation annotation = null;
        Position position = null;
        while (e.hasNext()) {
            String msg;
            Annotation a = (Annotation)e.next();
            AnnotationPreference preference = AbstractAnnotationHover.getAnnotationPreference(a);
            if (preference == null || (preference.getTextPreferenceKey() == null || !this.fStore.getBoolean(preference.getTextPreferenceKey())) && (preference.getHighlightPreferenceKey() == null || !this.fStore.getBoolean(preference.getHighlightPreferenceKey()))) continue;
            Position p = model.getPosition(a);
            int l = this.fAnnotationAccess.getLayer(a);
            if (l <= layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
            layer = l;
            annotation = a;
            position = p;
        }
        if (layer > -1) {
            return this.createAnnotationInfo(annotation, position, textViewer);
        }
        return null;
    }

    protected AnnotationInfo createAnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
        return new AnnotationInfo(annotation, position, textViewer);
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    private static AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    protected static class AnnotationInfo {
        public final Annotation annotation;
        public final Position position;
        public final ITextViewer viewer;

        public AnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
            this.annotation = annotation;
            this.position = position;
            this.viewer = textViewer;
        }

        public ICompletionProposal[] getCompletionProposals() {
            return new ICompletionProposal[0];
        }

        public void fillToolBar(ToolBarManager manager, IInformationControl infoControl) {
        }
    }

    private static class AnnotationInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private final DefaultMarkerAnnotationAccess fMarkerAnnotationAccess = new DefaultMarkerAnnotationAccess();
        private Control fFocusControl;
        private AnnotationInfo fInput;
        private Composite fParent;

        public AnnotationInformationControl(Shell parentShell, String statusFieldText) {
            super(parentShell, statusFieldText);
            this.create();
        }

        public AnnotationInformationControl(Shell parentShell, ToolBarManager toolBarManager) {
            super(parentShell, toolBarManager);
            this.create();
        }

        public void setInformation(String information) {
        }

        public void setInput(Object input) {
            Assert.isLegal((boolean)(input instanceof AnnotationInfo));
            this.fInput = (AnnotationInfo)input;
            this.disposeDeferredCreatedContent();
            this.deferredCreateContent();
        }

        public boolean hasContents() {
            return this.fInput != null;
        }

        private AnnotationInfo getAnnotationInfo() {
            return this.fInput;
        }

        public void setFocus() {
            super.setFocus();
            if (this.fFocusControl != null) {
                this.fFocusControl.setFocus();
            }
        }

        public final void setVisible(boolean visible) {
            if (!visible) {
                this.disposeDeferredCreatedContent();
            }
            super.setVisible(visible);
        }

        protected void disposeDeferredCreatedContent() {
            Control[] children = this.fParent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            ToolBarManager toolBarManager = this.getToolBarManager();
            if (toolBarManager != null) {
                toolBarManager.removeAll();
            }
        }

        protected void createContent(Composite parent) {
            this.fParent = parent;
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.fParent.setLayout((Layout)layout);
        }

        public Point computeSizeHint() {
            Point preferedSize = this.getShell().computeSize(-1, -1, true);
            Point constrains = this.getSizeConstraints();
            if (constrains == null) {
                return preferedSize;
            }
            int trimWidth = this.getShell().computeTrim((int)0, (int)0, (int)0, (int)0).width;
            Point constrainedSize = this.getShell().computeSize(constrains.x - trimWidth, -1, true);
            int width = Math.min(preferedSize.x, constrainedSize.x);
            int height = Math.max(preferedSize.y, constrainedSize.y);
            return new Point(width, height);
        }

        protected void fillToolbar() {
            ToolBarManager toolBarManager = this.getToolBarManager();
            if (toolBarManager == null) {
                return;
            }
            this.fInput.fillToolBar(toolBarManager, (IInformationControl)this);
            toolBarManager.update(true);
        }

        protected void deferredCreateContent() {
            this.fillToolbar();
            this.createAnnotationInformation(this.fParent, this.getAnnotationInfo().annotation);
            this.setColorAndFont((Control)this.fParent, this.fParent.getForeground(), this.fParent.getBackground(), JFaceResources.getDialogFont());
            this.fParent.layout(true);
        }

        private void setColorAndFont(Control control, Color foreground, Color background, Font font) {
            control.setForeground(foreground);
            control.setBackground(background);
            control.setFont(font);
            if (control instanceof Composite) {
                Control[] children = ((Composite)control).getChildren();
                int i = 0;
                while (i < children.length) {
                    this.setColorAndFont(children[i], foreground, background, font);
                    ++i;
                }
            }
        }

        private void createAnnotationInformation(Composite parent, final Annotation annotation) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 2;
            layout.marginWidth = 2;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            final Canvas canvas = new Canvas(composite, 524288);
            GridData gridData = new GridData(1, 1, false, false);
            gridData.widthHint = 17;
            gridData.heightHint = 16;
            canvas.setLayoutData((Object)gridData);
            canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setFont(null);
                    fMarkerAnnotationAccess.paint(annotation, e.gc, canvas, new Rectangle(0, 0, 16, 16));
                }
            });
            StyledText text = new StyledText(composite, 74);
            GridData data = new GridData(4, 4, true, true);
            text.setLayoutData((Object)data);
            String annotationText = annotation.getText();
            if (annotationText != null) {
                text.setText(annotationText);
            }
        }
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator presenterControlCreator) {
            this.fPresenterControlCreator = presenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new AnnotationInformationControl(parent, EditorsUI.getTooltipAffordanceString()){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return fPresenterControlCreator;
                }
            };
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
            }
            return true;
        }
    }

    private static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private PresenterControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new AnnotationInformationControl(parent, new ToolBarManager(0x800000));
        }
    }
}

