/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.HashSet2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.core.ExceptionAdapter;
import melnorme.utilbox.core.fntypes.RunnableX;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.misc.FileUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import melnorme.utilbox.misc.PathUtil;
import melnorme.utilbox.misc.StreamUtil;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.tests.TestsWorkingDir;

public class CommonTestUtils {
    public static final Charset DEFAULT_TESTDATA_ENCODING = StringUtil.UTF8;

    public static boolean TRUE() {
        return true;
    }

    public static void assertEquals(Object obj1, Object obj2) {
        Assert.equals(obj1, obj2);
    }

    public static void assertAreEqual(Object obj1, Object obj2) {
        Assert.AssertNamespace.assertTrue(CoreUtil.areEqual(obj1, obj2));
    }

    public static <T> T assertCast(Object object, Class<T> klass) {
        Assert.AssertNamespace.assertTrue(object == null || klass.isInstance(object));
        return (T)object;
    }

    public static <T> T assertInstance(Object object, Class<T> klass) {
        Assert.AssertNamespace.assertTrue(klass.isInstance(object));
        return (T)object;
    }

    public static void assertEqualArrays(Object[] arr1, Object[] arr2) {
        Assert.AssertNamespace.assertTrue(Arrays.equals(arr1, arr2));
    }

    public static <T> void assertContains(T[] array, T obj) {
        Assert.AssertNamespace.assertTrue(ArrayUtil.contains(array, obj));
    }

    public static void assertEquals(List<?> list1, List<?> list2) {
        CommonTestUtils.assertAreEqualLists(list1, list2);
    }

    public static void assertAreEqualLists(List<?> list1, List<?> list2) {
        if (list1 == null && list2 == null) {
            return;
        }
        if (list1.size() != list2.size()) {
            Assert.AssertNamespace.assertFail();
        }
        int ix = 0;
        while (ix < list1.size()) {
            Object obj1 = list1.get(ix);
            Object obj2 = list2.get(ix);
            CommonTestUtils.assertAreEqual(obj1, obj2);
            ++ix;
        }
    }

    public static void assertAreEqual(Indexable<?> list1, Indexable<?> list2) {
        if (list1 == null && list2 == null) {
            return;
        }
        if (list1.size() != list2.size()) {
            Assert.AssertNamespace.assertFail();
        }
        int ix = 0;
        while (ix < list1.size()) {
            Object obj1 = list1.get(ix);
            Object obj2 = list2.get(ix);
            CommonTestUtils.assertAreEqual(obj1, obj2);
            ++ix;
        }
    }

    public static void assertEqualSet(Set<?> result, Set<?> expected) {
        boolean equals = result.equals(expected);
        if (equals) {
            return;
        }
        HashSet2<?> resultExtra = new HashSet2((Collection<?>)result).removeAll2(expected);
        HashSet2<?> expectedMissing = new HashSet2((Collection<?>)expected).removeAll2(result);
        Assert.AssertNamespace.assertTrue(equals, "Obtained result set not equal to expected set. \n--- Extra elements in result set (" + resultExtra.size() + ") : --- \n" + StringUtil.collToString(resultExtra, "\n") + "\n" + "--- Extra elements in expected set (" + expectedMissing.size() + ") : --- \n" + StringUtil.collToString(expectedMissing, "\n") + "\n" + "== -- ==");
    }

    public static <EXC extends Throwable> void verifyThrows(RunnableX<EXC> runnable) {
        CommonTestUtils.verifyThrows(runnable, null);
    }

    public static <EXC extends Throwable> void verifyThrows(RunnableX<?> runnable, Class<EXC> klass) {
        CommonTestUtils.verifyThrows(runnable, klass, null);
    }

    public static <EXC extends Throwable> void verifyThrows(RunnableX<?> runnable, Class<EXC> klass, String expectedExceptionString) {
        try {
            try {
                if (klass != null && Assert.AssertFailedException.class.isAssignableFrom(klass)) {
                    Assert.assertionFailureExpected = true;
                }
                runnable.run();
                Assert.AssertNamespace.assertFail();
            }
            catch (Throwable e) {
                if (klass != null) {
                    Assert.AssertNamespace.assertTrue(klass.isInstance(e));
                }
                if (expectedExceptionString != null) {
                    String exceptionStr = e.toString();
                    Assert.AssertNamespace.assertTrue(exceptionStr.contains(expectedExceptionString));
                }
                Assert.assertionFailureExpected = false;
            }
        }
        finally {
            Assert.assertionFailureExpected = false;
        }
    }

    public static void assertExceptionContains(Exception exception, String string) {
        if (string == null) {
            Assert.AssertNamespace.assertTrue(exception == null);
        } else {
            Assert.AssertNamespace.assertTrue(exception.toString().contains(string));
        }
    }

    public static void assertExceptionMsgStart(Exception exception, String string) {
        if (string == null) {
            Assert.AssertNamespace.assertTrue(exception == null);
        } else {
            Assert.AssertNamespace.assertNotNull(exception);
            String message = exception.getMessage();
            Assert.AssertNamespace.assertNotNull(message);
            Assert.AssertNamespace.assertTrue(message.startsWith(string));
        }
    }

    public static <T> void assertStringContains(String string, CharSequence expectedContains) {
        Assert.AssertNamespace.assertTrue(string != null && string.contains(expectedContains));
    }

    public static <E, T extends Set<E>> T removeAll(T set, Collection<?> removeColl) {
        set.removeAll(removeColl);
        return set;
    }

    @SafeVarargs
    public static <T> T[] array(T ... elems) {
        return elems;
    }

    @SafeVarargs
    public static String[] strings(String ... elems) {
        return elems;
    }

    @SafeVarargs
    public static <T> ArrayList2<T> list(T ... elems) {
        return ArrayList2.create(elems);
    }

    @SafeVarargs
    public static <T> HashSet2<T> hashSet(T ... elems) {
        return new HashSet2<T>(Arrays.asList(elems));
    }

    public static <T> Set<T> unmodifiable(Set<T> set) {
        return Collections.unmodifiableSet(set);
    }

    public static <T> List<T> unmodifiable(List<T> set) {
        return Collections.unmodifiableList(set);
    }

    public static <T> Collection<T> unmodifiable(Collection<T> set) {
        return Collections.unmodifiableCollection(set);
    }

    public static String safeToString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static Path path(String pathString) {
        return PathUtil.createValidPath(pathString);
    }

    public static Location loc(String pathString) {
        Path createValidPath = PathUtil.createValidPath(pathString);
        return CommonTestUtils.loc(createValidPath);
    }

    public static Location loc(Path absolutePath) {
        return Location.fromAbsolutePath(absolutePath);
    }

    public static Location loc(Location baseLoc, String pathString) {
        return baseLoc.resolve(PathUtil.createValidPath(pathString));
    }

    public static Location workingDirLoc(String relativePath) {
        return TestsWorkingDir.getWorkingDir(relativePath);
    }

    public static String readStringFromFile(Path path) {
        return CommonTestUtils.readStringFromFile(Location.create_fromValid(path));
    }

    public static String readStringFromFile(File file) {
        return CommonTestUtils.readStringFromFile(Location.create_fromValid(file.toPath()));
    }

    public static String readStringFromFile(Location loc) {
        try {
            return FileUtil.readStringFromFile(loc.toFile(), DEFAULT_TESTDATA_ENCODING);
        }
        catch (IOException e) {
            throw ExceptionAdapter.unchecked(e);
        }
    }

    public static void writeStringToFile(Path file, String string) {
        CommonTestUtils.writeStringToFile(Location.create_fromValid(file), string);
    }

    public static void writeStringToFile(File file, String string) {
        CommonTestUtils.writeStringToFile(Location.create_fromValid(file.toPath()), string);
    }

    public static void writeStringToFile(Location file, String string) {
        try {
            StreamUtil.writeStringToStream(string, new FileOutputStream(file.toFile()), DEFAULT_TESTDATA_ENCODING);
        }
        catch (IOException e) {
            throw ExceptionAdapter.unchecked(e);
        }
    }

    public static void appendStringToFile(File file, String string) {
        try {
            StreamUtil.writeStringToStream(string, new FileOutputStream(file, true), DEFAULT_TESTDATA_ENCODING);
        }
        catch (IOException e) {
            throw ExceptionAdapter.unchecked(e);
        }
    }

    public static String getClassResourceAsString(Class<?> klass, String resourceName) {
        return MiscUtil.getClassResource(klass, resourceName);
    }
}

