/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.tests;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.DevelopmentCodeMarkers;
import melnorme.utilbox.misc.MiscUtil;
import melnorme.utilbox.misc.SimpleLogger;
import melnorme.utilbox.ownership.OwnedObjects;
import melnorme.utilbox.tests.CommonTestUtils;
import org.junit.After;
import org.junit.Before;

public class CommonTest
extends CommonTestUtils {
    public static PrintStream testsLogger = System.out;
    public static SimpleLogger testsLogVerbose = SimpleLogger.create("verbose");
    public static Set<String> executedTests = new HashSet<String>();
    protected final OwnedObjects owned = new OwnedObjects();

    public CommonTest() {
        DevelopmentCodeMarkers.TESTS_MODE = true;
        if (this.isJUnitTest()) {
            String klassName = this.getClass().getSimpleName();
            Assert.AssertNamespace.assertTrue(klassName.isEmpty() || klassName.startsWith("Test") || klassName.endsWith("Test") || klassName.endsWith("Tests"));
        }
    }

    public boolean isJUnitTest() {
        return true;
    }

    @Before
    public void printSeparator() throws Exception {
        String simpleName = this.getClass().getSimpleName();
        if (!executedTests.contains(simpleName)) {
            testsLogger.println("===============================  " + simpleName + "  ===============================");
            executedTests.add(simpleName);
        }
    }

    @After
    public void dispose() throws Exception {
        this.disposeOwned();
    }

    public void disposeOwned() {
        this.owned.disposeAll();
    }

    public String getClassResource(String resourceName) {
        return MiscUtil.getClassResource(this.getClass(), resourceName);
    }
}

