/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.status;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.Severity;

public class StatusException
extends CommonException
implements IStatusMessage {
    protected final Severity severity;

    public StatusException(String message) {
        this(Severity.ERROR, message, null);
    }

    public StatusException(Severity severity, String message) {
        this(severity, message, null);
    }

    public StatusException(Severity severity, String message, Throwable cause) {
        super(message, cause);
        this.severity = Assert.AssertNamespace.assertNotNull(severity);
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    public StatusException toStatusException() {
        return this;
    }

    @Override
    public StatusException toStatusException(Severity severity) {
        return this;
    }

    public static StatusException toStatusException(IStatusMessage status) {
        if (status instanceof StatusException) {
            return (StatusException)status;
        }
        return new StatusException(status.getSeverity(), status.getMessage());
    }
}

