/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.process;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.ILogHandler;
import melnorme.utilbox.process.ExternalProcessHelper;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;

public class ExternalProcessNotifyingHelper
extends ExternalProcessHelper {
    protected final ILogHandler logHandler;
    protected final Indexable<IProcessOutputListener> listeners;
    protected final FAwaitListeners awaitListeners;
    protected final CountDownLatch listenersTerminationLatch = new CountDownLatch(1);

    public ExternalProcessNotifyingHelper(Process process, boolean readStdErr, ICancelMonitor cancelMonitor, Indexable<IProcessOutputListener> listeners, ILogHandler logHandler) {
        this(process, readStdErr, FStartReaders.YES, FAwaitListeners.YES, cancelMonitor, listeners, logHandler);
    }

    protected ExternalProcessNotifyingHelper(Process process, boolean readStdErr, FStartReaders startReaders, FAwaitListeners awaitListeners, ICancelMonitor cancelMonitor, Indexable<IProcessOutputListener> listeners, ILogHandler logHandler) {
        super(process, readStdErr, false, cancelMonitor);
        this.awaitListeners = Assert.AssertNamespace.assertNotNull(awaitListeners);
        this.listeners = Assert.AssertNamespace.assertNotNull(listeners);
        this.logHandler = Assert.AssertNamespace.assertNotNull(logHandler);
        if (startReaders.isTrue()) {
            this.startReaderThreads();
        }
    }

    @Override
    protected Runnable createMainReaderTask() {
        this.mainReader = new ExternalProcessHelper.ReadAllBytesTask(this.process.getInputStream()){

            @Override
            protected void notifyReadChunk(byte[] buffer, int offset, int readCount) {
                ExternalProcessNotifyingHelper.this.notifyDataRead(buffer, offset, readCount, true);
            }
        };
        return this.mainReader.runnableFuture;
    }

    @Override
    protected Runnable createStdErrReaderTask() {
        this.stderrReader = new ExternalProcessHelper.ReadAllBytesTask(this.process.getErrorStream()){

            @Override
            protected void notifyReadChunk(byte[] buffer, int offset, int readCount) {
                ExternalProcessNotifyingHelper.this.notifyDataRead(buffer, offset, readCount, false);
            }
        };
        return this.stderrReader.runnableFuture;
    }

    protected void notifyDataRead(byte[] buffer, int offset, int readCount, boolean stdOut) {
        for (IProcessOutputListener pol : this.listeners) {
            try {
                if (stdOut) {
                    pol.notifyStdOutListeners(buffer, offset, readCount);
                    continue;
                }
                pol.notifyStdErrListeners(buffer, offset, readCount);
            }
            catch (RuntimeException e) {
                this.handleListenerException("Listener internal error at notifyDataRead.", e);
            }
        }
    }

    @Override
    public void mainReaderThread_Terminated() {
        while (true) {
            try {
                this.readersTerminationLatch.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        try {
            this.mainReaderThread_notifyProcessTerminatedAndRead(this.process.exitValue());
        }
        finally {
            this.listenersTerminationLatch.countDown();
        }
    }

    protected void mainReaderThread_notifyProcessTerminatedAndRead(int exitCode) {
        for (IProcessOutputListener pol : this.listeners) {
            try {
                pol.notifyProcessTerminatedAndRead(exitCode);
            }
            catch (RuntimeException e) {
                this.handleListenerException("Listener internal error at notifyProcessTerminatedAndRead", e);
            }
        }
    }

    protected void handleListenerException(String message, RuntimeException e) {
        this.logHandler.logStatus(new StatusException(Severity.ERROR, message, e));
    }

    @Override
    protected boolean doAwaitTermination(int cancelPollPeriodMs) throws InterruptedException {
        if (this.awaitListeners.isTrue()) {
            return this.listenersTerminationLatch.await(cancelPollPeriodMs, TimeUnit.MILLISECONDS);
        }
        return super.doAwaitTermination(cancelPollPeriodMs);
    }

    public static enum FAwaitListeners {
        YES,
        NO;


        public boolean isTrue() {
            return this == YES;
        }
    }

    public static enum FStartReaders {
        YES,
        NO;


        public boolean isTrue() {
            return this == YES;
        }
    }

    public static interface IProcessOutputListener {
        public void notifyStdOutListeners(byte[] var1, int var2, int var3);

        public void notifyStdErrListeners(byte[] var1, int var2, int var3);

        public void notifyProcessTerminatedAndRead(int var1);
    }
}

