/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.process;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractExternalProcessHelper {
    public static final int NO_TIMEOUT = -1;
    protected final Process process;
    protected final boolean readStdErr;
    protected final CountDownLatch readersTerminationLatch;
    protected final Thread mainReaderThread;
    protected final Thread stderrReaderThread;

    public AbstractExternalProcessHelper(ProcessBuilder pb) throws IOException {
        this(pb.start(), !pb.redirectErrorStream(), true);
    }

    public AbstractExternalProcessHelper(Process process, boolean readStdErr, boolean startReaders) {
        this.process = process;
        this.readStdErr = readStdErr;
        this.readersTerminationLatch = new CountDownLatch(2);
        this.mainReaderThread = new ProcessHelperMainThread(this.createMainReaderTask());
        if (readStdErr) {
            this.stderrReaderThread = new ProcessHelperStdErrThread(this.createStdErrReaderTask());
        } else {
            this.readersTerminationLatch.countDown();
            this.stderrReaderThread = null;
        }
        if (startReaders) {
            this.startReaderThreads();
        }
    }

    public void startReaderThreads() {
        this.mainReaderThread.start();
        if (this.stderrReaderThread != null) {
            this.stderrReaderThread.start();
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean isReadingStdErr() {
        return this.readStdErr;
    }

    public boolean areReadersTerminated() {
        return this.readersTerminationLatch.getCount() == 0L;
    }

    protected abstract Runnable createMainReaderTask();

    protected abstract Runnable createStdErrReaderTask();

    protected String getBaseNameForWorkerThreads() {
        return this.getClass().getSimpleName();
    }

    public void mainReaderThread_Terminated() {
    }

    protected int awaitTermination(int timeoutMs) throws InterruptedException, TimeoutException {
        int waitedTime = 0;
        int cancelPollPeriodMs;
        boolean latchSuccess;
        while (!(latchSuccess = this.doAwaitTermination(cancelPollPeriodMs = this.getCancelPollingPeriodMs()))) {
            if (this.isCanceled()) {
                throw new InterruptedException();
            }
            if (timeoutMs != -1 && waitedTime >= timeoutMs) {
                throw new TimeoutException();
            }
            waitedTime += cancelPollPeriodMs;
        }
        return this.process.exitValue();
    }

    protected boolean doAwaitTermination(int cancelPollPeriodMs) throws InterruptedException {
        return this.readersTerminationLatch.await(cancelPollPeriodMs, TimeUnit.MILLISECONDS);
    }

    protected int getCancelPollingPeriodMs() {
        return 200;
    }

    protected abstract boolean isCanceled();

    protected class ProcessHelperMainThread
    extends Thread {
        public ProcessHelperMainThread(Runnable runnable) {
            super(runnable, String.valueOf(AbstractExternalProcessHelper.this.getBaseNameForWorkerThreads()) + ".MainWorker");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                this.waitForProcessIndefinitely();
                AbstractExternalProcessHelper.this.readersTerminationLatch.countDown();
                AbstractExternalProcessHelper.this.mainReaderThread_Terminated();
            }
        }

        protected void waitForProcessIndefinitely() {
            while (true) {
                try {
                    AbstractExternalProcessHelper.this.process.waitFor();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    protected class ProcessHelperStdErrThread
    extends Thread {
        public ProcessHelperStdErrThread(Runnable runnable) {
            super(runnable, String.valueOf(AbstractExternalProcessHelper.this.getBaseNameForWorkerThreads()) + ".StdErrWorker");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                AbstractExternalProcessHelper.this.readersTerminationLatch.countDown();
            }
        }
    }
}

