/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.ownership;

import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.ownership.IOwner;

public class OwnedObjects
extends ArrayList2<IDisposable>
implements IOwner,
IDisposable {
    protected boolean disposed = false;

    protected void checkDisposed() {
        Assert.AssertNamespace.assertTrue(!this.disposed);
    }

    @Override
    public void bind(IDisposable disposable) {
        this.add(disposable);
    }

    @Override
    public boolean unbind(IDisposable disposable) {
        return this.remove(disposable);
    }

    @Override
    public boolean add(IDisposable e) {
        this.checkDisposed();
        return super.add(e);
    }

    @Override
    public IDisposable remove(int index) {
        this.checkDisposed();
        return (IDisposable)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.checkDisposed();
        return super.remove(o);
    }

    @Override
    public void dispose() {
        this.disposeAll();
    }

    @Override
    public void disposeAll() {
        for (IDisposable disposable : this) {
            disposable.dispose();
        }
        this.clear();
        this.disposed = true;
    }
}

