/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.ownership;

import melnorme.utilbox.core.Assert;

public interface Disposable
extends AutoCloseable {
    @Override
    default public void close() {
        this.dispose();
    }

    public void dispose();

    public static <T extends Disposable> T dispose(T disposable) {
        if (disposable != null) {
            disposable.dispose();
        }
        return null;
    }

    public static class CheckedDisposable
    implements Disposable {
        protected final Disposable disposable;
        protected boolean disposed = false;

        public CheckedDisposable(Disposable disposable) {
            this.disposable = Assert.AssertNamespace.assertNotNull(disposable);
        }

        @Override
        public void dispose() {
            if (this.disposed) {
                Assert.AssertNamespace.assertFail();
            }
            this.disposable.dispose();
            this.disposed = true;
        }
    }
}

