/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;

public class NumberUtil {
    public static boolean isInRange(int min, int number, int max) {
        Assert.AssertNamespace.assertTrue(min <= max);
        return min <= number && number <= max;
    }

    public static boolean isInsideRange(int min, int number, int max) {
        Assert.AssertNamespace.assertTrue(min <= max);
        return min < number && number < max;
    }

    public static int capBetween(int min, int number, int max) {
        Assert.AssertNamespace.assertTrue(min <= max);
        return Math.min(max, Math.max(min, number));
    }

    public static int nearestToZero(int a, int b) {
        if (Math.abs(a) < Math.abs(b)) {
            return a;
        }
        return b;
    }

    public static int fartherFromZero(int a, int b) {
        if (Math.abs(a) > Math.abs(b)) {
            return a;
        }
        return b;
    }

    public static int parseInt(String integerString) throws CommonException {
        try {
            return Integer.parseInt(integerString);
        }
        catch (NumberFormatException e) {
            throw new CommonException("Invalid integer: `" + integerString + "`");
        }
    }

    public static int parseInt(String integerString, String errorMessage) throws CommonException {
        try {
            return Integer.parseInt(integerString);
        }
        catch (NumberFormatException e) {
            throw new CommonException(errorMessage, null);
        }
    }

    public static int parseInt(String string, int defaultValue) {
        int intValue = defaultValue;
        try {
            if (string != null) {
                intValue = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    public static int parsePositiveInt(String integerString) throws CommonException {
        int integer = NumberUtil.parseInt(integerString);
        if (integer < 0) {
            throw new CommonException("Integer is not positive: " + integerString);
        }
        return integer;
    }

    public static boolean isDigit(char ch, int radix) {
        char maxNumberDigit = (char)Math.min(48 + (radix - 1), 57);
        if (ch >= '0' && ch <= maxNumberDigit) {
            return true;
        }
        return radix > 10 && (ch >= 'a' && ch < 97 + (radix - 10) || ch >= 'A' && ch < 65 + (radix - 10));
    }
}

