/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.misc;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;

public class ArrayUtil {
    public static final Object[] EMPTY_ARRAY = new Object[0];

    public static Object[] nullToEmpty(Object[] array) {
        return array == null ? EMPTY_ARRAY : array;
    }

    public static <T> T[] nullToEmpty(T[] array, Class<T> componentType) {
        return array == null ? ArrayUtil.create(0, componentType) : array;
    }

    public static <T> T[] create(int length, Class<T> componentType) {
        return (Object[])Array.newInstance(componentType, length);
    }

    public static <T> T[] create(Class<T> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    public static <T> T[] createWithSameComponentType(int length, T[] similarArray) {
        return (Object[])Array.newInstance(similarArray.getClass().getComponentType(), length);
    }

    public static <T> T[] singletonArray(T element, Class<T> componentType) {
        if (element == null) {
            return ArrayUtil.create(componentType, 0);
        }
        T[] newArray = ArrayUtil.create(componentType, 1);
        newArray[0] = element;
        return newArray;
    }

    public static <T> T[] createFrom(Collection<? extends T> list, Class<T> componentType) {
        if (list == null) {
            return ArrayUtil.create(componentType, 0);
        }
        return list.toArray(ArrayUtil.create(componentType, list.size()));
    }

    public static Object[] createFrom(Collection<?> list) {
        return ArrayUtil.createFrom(list, Object.class);
    }

    public static <E> E[] copyFrom(E[] array, Class<E> componentType) {
        E[] newArray = ArrayUtil.create(array.length, componentType);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static <T> T[] toArray(Collection<? extends T> list, Class<T> componentType) {
        if (list == null) {
            return null;
        }
        return list.toArray(ArrayUtil.create(componentType, list.size()));
    }

    public static <T> T[] copyFrom(T[] array, int newLength) {
        T[] copy = ArrayUtil.createWithSameComponentType(newLength, array);
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static char[] copyFrom(char[] array, int newLength) {
        char[] copy = (char[])Array.newInstance(Character.TYPE, newLength);
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static byte[] copyFrom(byte[] array, int newLength) {
        byte[] copy = (byte[])Array.newInstance(Byte.TYPE, newLength);
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static int[] copyFrom(int[] array, int newLength) {
        int[] copy = (int[])Array.newInstance(Integer.TYPE, newLength);
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static int[] copyFrom(int[] array) {
        return ArrayUtil.copyFrom(array, array.length);
    }

    public static <T> T[] copyFrom(T[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        return Arrays.copyOfRange(original, from, to, newType);
    }

    public static int[] createIntArray(List<? extends Integer> coll) {
        int[] array = new int[coll.size()];
        int i = 0;
        while (i < coll.size()) {
            array[i] = coll.get(i);
            ++i;
        }
        return array;
    }

    public static <T> T[] newSameSize(List<?> list, Class<T> cpType) {
        if (list == null) {
            return ArrayUtil.create(cpType, 0);
        }
        return ArrayUtil.create(cpType, list.size());
    }

    public static void copyToRange(byte[] src, byte[] dest, int destIx) {
        Assert.AssertNamespace.assertTrue(src.length < dest.length - destIx);
        System.arraycopy(src, 0, dest, destIx, src.length);
    }

    public static <T> T[] append(T[] base, T element) {
        T[] newArray = ArrayUtil.copyFrom(base, base.length + 1);
        newArray[base.length] = element;
        return newArray;
    }

    @SafeVarargs
    public static <T> T[] prepend(T first, T ... rest) {
        T[] newArray = ArrayUtil.createWithSameComponentType(rest.length + 1, rest);
        newArray[0] = first;
        System.arraycopy(rest, 0, newArray, 1, rest.length);
        return newArray;
    }

    @SafeVarargs
    public static <T> T[] concat(T[] base, T ... other) {
        return ArrayUtil.concat(base, other, other.length);
    }

    public static <T> T[] concat(T[] base, T[] other, int appendCount) {
        T[] newArray = ArrayUtil.copyFrom(base, base.length + appendCount);
        System.arraycopy(other, 0, newArray, base.length, appendCount);
        return newArray;
    }

    public static byte[] concat(byte[] base, byte[] other, int appendCount) {
        int length = base.length;
        byte[] newArray = ArrayUtil.copyFrom(base, base.length + appendCount);
        System.arraycopy(other, 0, newArray, length, appendCount);
        return newArray;
    }

    public static char[] concat(char[] base, char[] other, int appendCount) {
        int length = base.length;
        char[] newArray = ArrayUtil.copyFrom(base, base.length + appendCount);
        System.arraycopy(other, 0, newArray, length, appendCount);
        return newArray;
    }

    public static <T> T[] remove(T[] array, T objToRemove) {
        int i = 0;
        while (i < array.length) {
            T elem = array[i];
            if (CoreUtil.areEqual(elem, objToRemove)) {
                return ArrayUtil.removeAt(array, i);
            }
            ++i;
        }
        return array;
    }

    public static <T> T[] removeAt(T[] array, int ix) {
        T[] newArray = ArrayUtil.copyFrom(array, array.length - 1);
        System.arraycopy(array, 0, newArray, 0, ix);
        System.arraycopy(array, ix + 1, newArray, ix, array.length - ix - 1);
        return newArray;
    }

    public static <T> T[] removeLast(T[] array, int count) {
        Assert.AssertNamespace.assertTrue(array.length >= count);
        T[] newArray = ArrayUtil.copyFrom(array, array.length - count);
        return newArray;
    }

    public static <T> T[] removeAll(T[] array, T objToRemove) {
        int removeCount = 0;
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T elem = TArray[n2];
            if (CoreUtil.areEqual(elem, objToRemove)) {
                ++removeCount;
            }
            ++n2;
        }
        if (removeCount == 0) {
            return array;
        }
        int ix = 0;
        T[] newArray = ArrayUtil.createWithSameComponentType(array.length - removeCount, array);
        T[] TArray2 = array;
        int n3 = array.length;
        int n4 = 0;
        while (n4 < n3) {
            T elem = TArray2[n4];
            if (!CoreUtil.areEqual(elem, objToRemove)) {
                newArray[ix] = elem;
                ++ix;
            }
            ++n4;
        }
        return newArray;
    }

    public static <T> T getLastElement(T[] array) {
        if (array.length == 0) {
            return null;
        }
        return array[array.length - 1];
    }

    public static <T> int indexOf(T[] array, T elem) {
        if (elem == null) {
            int ix = 0;
            while (ix < array.length) {
                if (array[ix] == null) {
                    return ix;
                }
                ++ix;
            }
        } else {
            int ix = 0;
            while (ix < array.length) {
                if (elem.equals(array[ix])) {
                    return ix;
                }
                ++ix;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T obj) {
        return ArrayUtil.indexOf(array, obj) != -1;
    }

    public static int indexOf(byte[] array, byte elem) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == elem) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char elem) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == elem) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int indexOfIdentity(T[] array, T elem) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == elem) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> boolean search(T[] array, Predicate<T> predicate) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T elem = TArray[n2];
            if (predicate.test(elem)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> Object[] map(T[] array, Function<? super T, ? extends Object> evalFunction) {
        return ArrayUtil.map(array, evalFunction, Object.class);
    }

    public static <T, R> R[] map(T[] array, Function<? super T, ? extends R> evalFunction, Class<R> klass) {
        R[] newArray = ArrayUtil.create(array.length, klass);
        int i = 0;
        while (i < newArray.length) {
            newArray[i] = evalFunction.apply(array[i]);
            ++i;
        }
        return newArray;
    }

    public static <T> Object[] map(Collection<T> coll, Function<? super T, ? extends Object> evalFunction) {
        return ArrayUtil.map(coll, evalFunction, Object.class);
    }

    public static <T> Object[] map(Collection2<T> coll, Function<? super T, ? extends Object> evalFunction) {
        return ArrayUtil.map(coll, evalFunction, Object.class);
    }

    public static <T, R> R[] map(Collection<T> coll, Function<? super T, ? extends R> evalFunction, Class<R> klass) {
        R[] newArray = ArrayUtil.create(coll.size(), klass);
        int i = 0;
        for (T elem : coll) {
            newArray[i] = evalFunction.apply(elem);
            ++i;
        }
        return newArray;
    }

    public static <T, R> R[] map(Collection2<T> coll, Function<? super T, ? extends R> evalFunction, Class<R> klass) {
        R[] newArray = ArrayUtil.create(coll.size(), klass);
        int i = 0;
        for (Object elem : coll) {
            newArray[i] = evalFunction.apply(elem);
            ++i;
        }
        return newArray;
    }

    public static <T> T[] filter(T[] array, Predicate<T> predicate) {
        T[] newArray = ArrayUtil.createWithSameComponentType(array.length, array);
        Assert.AssertNamespace.assertTrue(newArray.length <= array.length);
        int newIx = 0;
        int arrayIx = 0;
        while (arrayIx < array.length) {
            if (predicate.test(array[arrayIx])) {
                newArray[newIx] = array[arrayIx];
                ++newIx;
                ++arrayIx;
                continue;
            }
            ++arrayIx;
        }
        return newIx == arrayIx ? newArray : Arrays.copyOfRange(newArray, 0, newIx);
    }
}

