/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.fields.validation;

import java.util.function.Supplier;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.fields.validation.Validator;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.StatusException;
import melnorme.utilbox.status.StatusLevel;

public interface ValidationSource {
    public IStatusMessage getValidationStatus();

    default public StatusLevel getValidationStatusLevel() {
        IStatusMessage se = this.getValidationStatus();
        return se == null ? StatusLevel.OK : se.getSeverity().toStatusLevel();
    }

    default public void validate() throws StatusException {
        IStatusMessage validationStatus = this.getValidationStatus();
        if (validationStatus != null) {
            throw validationStatus.toStatusException();
        }
    }

    public static IStatusMessage getHighestStatus(Iterable<? extends ValidationSource> validationSources) {
        IStatusMessage highestSE = null;
        for (ValidationSource validationSource : validationSources) {
            IStatusMessage se = validationSource.getValidationStatus();
            if (se == null || highestSE != null && !se.isHigherSeverity(highestSE)) continue;
            highestSE = se;
        }
        return highestSE;
    }

    public static class ValidatableField<SOURCE>
    implements ValidationSourceX {
        public final Supplier<SOURCE> property;
        public final Validator<SOURCE, ?> validator;

        public ValidatableField(Supplier<SOURCE> field, Validator<SOURCE, ?> validator) {
            this.property = Assert.AssertNamespace.assertNotNull(field);
            this.validator = Assert.AssertNamespace.assertNotNull(validator);
        }

        @Override
        public void validate() throws StatusException {
            this.validator.validateField(this.property.get());
        }
    }

    public static interface ValidationSourceX
    extends ValidationSource {
        @Override
        default public IStatusMessage getValidationStatus() {
            try {
                this.validate();
                return null;
            }
            catch (StatusException e) {
                return e;
            }
        }

        @Override
        public void validate() throws StatusException;
    }
}

