/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.fields.validation;

import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.fields.Field;
import melnorme.utilbox.fields.IFieldView;
import melnorme.utilbox.fields.validation.IValidatableField;
import melnorme.utilbox.fields.validation.ValidationSource;
import melnorme.utilbox.fields.validation.Validator;
import melnorme.utilbox.status.IStatusMessage;

public class ValidationField
extends Field<IStatusMessage>
implements ValidationSource {
    protected final ArrayList2<ValidationSource> validators = new ArrayList2();
    protected IStatusMessage explicitStatus;

    public ValidationField() {
        super(null);
        this.validators.add(() -> this.explicitStatus);
    }

    public <SOURCE> void addFieldValidator(boolean init, IFieldView<SOURCE> field, Validator<SOURCE, ?> validator) {
        this.addFieldValidation(init, field, new ValidationSource.ValidatableField<SOURCE>(field, validator));
    }

    public final void addFieldValidationX(boolean init, IFieldView<?> field, ValidationSource.ValidationSourceX validationSource) {
        this.addFieldValidation(init, field, validationSource);
    }

    public void addFieldValidation(boolean init, IFieldView<?> field, ValidationSource validationSource) {
        this.validators.add(validationSource);
        field.registerListener(init, __ -> this.updateFieldValue());
    }

    public void addValidatableField(boolean init, IValidatableField<?> statusField) {
        this.addFieldValidation(init, statusField, statusField);
    }

    public void addStatusField(boolean init, IFieldView<IStatusMessage> statusField) {
        this.addFieldValidation(init, statusField, () -> (IStatusMessage)statusField.getFieldValue());
    }

    public void updateFieldValue() {
        this.setFieldValue(ValidationSource.getHighestStatus(this.validators));
    }

    @Override
    public IStatusMessage getValidationStatus() {
        return (IStatusMessage)this.getFieldValue();
    }

    public void setExplicitStatus(IStatusMessage explicitStatus) {
        this.doSetExplicitStatus(explicitStatus);
        this.updateFieldValue();
    }

    protected void doSetExplicitStatus(IStatusMessage explicitStatus) {
        this.explicitStatus = explicitStatus;
    }
}

