/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.fields;

import java.util.function.Supplier;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.ownership.IOwner;

public interface IFieldView<VALUE>
extends Supplier<VALUE> {
    public static final IFieldView<Object> NULL_FIELD_VIEW = new IFieldView<Object>(){

        @Override
        public Object getFieldValue() {
            return null;
        }

        @Override
        public void addListener(FieldValueListener<Object> listener) {
        }

        @Override
        public void removeListener(FieldValueListener<Object> listener) {
        }
    };

    @Override
    default public VALUE get() {
        return this.getFieldValue();
    }

    public VALUE getFieldValue();

    public void addListener(FieldValueListener<? super VALUE> var1);

    default public void addListener(boolean initialize, FieldValueListener<VALUE> listener) {
        this.addListener(listener);
        if (initialize) {
            listener.fieldValueChanged(this.getFieldValue());
        }
    }

    default public void addChangeListener(FieldValueListener.FieldChangeListener listener) {
        this.addListener(listener);
    }

    public void removeListener(FieldValueListener<? super VALUE> var1);

    default public FieldListenerRegistration registerListener(FieldValueListener<? super VALUE> listener) {
        this.addListener(listener);
        return new FieldListenerRegistration(this, listener);
    }

    default public FieldListenerRegistration registerListener(boolean initListener, FieldValueListener<? super VALUE> listener) {
        FieldListenerRegistration binding = this.registerListener(listener);
        if (initListener) {
            listener.fieldValueChanged(this.getFieldValue());
        }
        return binding;
    }

    default public FieldListenerRegistration registerChangeListener(boolean initListener, FieldValueListener.FieldChangeListener listener) {
        return this.registerListener(initListener, listener);
    }

    default public void bindOwnedListener(IOwner owner, FieldValueListener<VALUE> listener) {
        this.registerListener(listener).bindLifetime(owner);
    }

    default public void bindOwnedListener(IOwner owner, boolean initListener, FieldValueListener<VALUE> listener) {
        this.registerListener(listener).bindLifetime(owner);
        if (initListener) {
            listener.fieldValueChanged(this.getFieldValue());
        }
    }

    public static <T> IFieldView<T> NULL_FIELD_VIEW() {
        return NULL_FIELD_VIEW;
    }

    public static class FieldListenerRegistration
    implements IDisposable {
        protected final IFieldView<?> field;
        protected final FieldValueListener listener;

        public <T> FieldListenerRegistration(IFieldView<T> field, FieldValueListener<? super T> listener) {
            this.field = Assert.AssertNamespace.assertNotNull(field);
            this.listener = Assert.AssertNamespace.assertNotNull(listener);
        }

        @Override
        public void dispose() {
            this.field.removeListener(this.listener);
        }

        public void bindLifetime(IOwner owner) {
            owner.bind(this);
        }
    }
}

