/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.fields;

import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.fields.IField;
import melnorme.utilbox.fields.ListenerListHelper;

public class Field<TYPE>
implements IField<TYPE> {
    protected final ListenerListHelper<FieldValueListener<? super TYPE>> listeners = new ListenerListHelper();
    private TYPE value;
    protected boolean notifyingListeners;

    public Field() {
        this(null);
    }

    public Field(TYPE defaultFieldValue) {
        this.value = defaultFieldValue;
    }

    @Override
    public void addListener(FieldValueListener<? super TYPE> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(FieldValueListener<? super TYPE> listener) {
        this.listeners.removeListener(listener);
    }

    protected Indexable<FieldValueListener<? super TYPE>> getListeners() {
        return this.listeners.getListeners();
    }

    public void fireFieldValueChanged() {
        TYPE newFieldValue = this.getFieldValue();
        this.fieldValueChanged();
        for (FieldValueListener fieldValueListener : this.listeners.getListeners()) {
            fieldValueListener.fieldValueChanged(newFieldValue);
        }
    }

    protected void fieldValueChanged() {
    }

    @Override
    public TYPE getFieldValue() {
        return this.value;
    }

    @Override
    public void setFieldValue(TYPE value) {
        this.doSetFieldValue(value);
    }

    public boolean isNotifyingListeners() {
        return this.notifyingListeners;
    }

    protected void doSetFieldValue(TYPE newValue) {
        if (this.notifyingListeners) {
            this.handleReentrantSetValue(newValue);
        } else {
            this.value = newValue;
            this.notifyingListeners = true;
            try {
                this.fireFieldValueChanged();
            }
            finally {
                this.notifyingListeners = false;
            }
        }
    }

    protected void handleReentrantSetValue(TYPE newValue) {
        this.value = newValue;
    }
}

