/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.core.fntypes;

import melnorme.utilbox.core.Assert;

public class Result<DATA, EXC extends Throwable> {
    protected final DATA resultValue;
    protected final Throwable resultException;

    public static <DATA, EXC extends Throwable> Result<DATA, EXC> fromValue(DATA resultValue) {
        return new Result<DATA, EXC>(resultValue);
    }

    public static <DATA, EXC extends Throwable> Result<DATA, EXC> fromException(EXC exception) {
        return new Result<Object, EXC>(null, exception);
    }

    public static <DATA, EXC extends Throwable> Result<DATA, EXC> fromRuntimeException(RuntimeException exception) {
        return new Result<Object, EXC>(null, exception, null);
    }

    public Result(DATA resultValue) {
        this(resultValue, null);
    }

    public Result(DATA resultValue, EXC resultException) {
        this(resultValue, (Throwable)resultException, null);
    }

    protected Result(DATA resultValue, Throwable resultException, Void dummy) {
        this.resultValue = resultValue;
        this.resultException = resultException;
        Assert.AssertNamespace.assertTrue(resultValue == null || resultException == null);
    }

    public DATA get() throws EXC {
        this.throwIfExceptionResult();
        return this.resultValue;
    }

    public boolean isSuccessful() {
        return this.resultException == null;
    }

    public boolean isException() {
        return !this.isSuccessful();
    }

    public DATA getOrNull() {
        try {
            return this.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Throwable getResultException() {
        return this.resultException;
    }

    protected void throwIfExceptionResult() throws EXC {
        if (this.resultException instanceof RuntimeException) {
            throw (RuntimeException)this.resultException;
        }
        if (this.resultException != null) {
            throw this.resultException;
        }
    }
}

