/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.core;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import melnorme.utilbox.core.Assert;

public class ExceptionAdapter
extends RuntimeException {
    protected int checkedLength;

    protected ExceptionAdapter(Exception e) {
        super(e);
        Assert.AssertNamespace.assertNotNull(e);
        StackTraceElement[] est = e.getStackTrace();
        this.checkedLength = est.length - this.getStackTrace().length;
        StackTraceElement ste = this.getStackTrace()[0];
        String firstMethod = String.valueOf(ste.getClassName()) + "." + ste.getMethodName();
        if (firstMethod.endsWith("ExceptionAdapter.unchecked")) {
            ++this.checkedLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printStackTraceAppendable(Appendable pr) {
        Appendable appendable = pr;
        synchronized (appendable) {
            try {
                pr.append(this.toString());
                StackTraceElement[] trace = this.getCause().getStackTrace();
                int i = 0;
                while (i < trace.length) {
                    pr.append("\tat " + trace[i]);
                    if (i == this.checkedLength) {
                        pr.append(" [UNCHECKED]");
                    }
                    pr.append("\n");
                    ++i;
                }
            }
            catch (IOException e) {
                Assert.AssertNamespace.assertFail();
            }
        }
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        this.printStackTraceAppendable(ps);
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        this.printStackTraceAppendable(pw);
    }

    @Override
    public Exception getCause() {
        return (Exception)super.getCause();
    }

    public void rethrow() throws Exception {
        throw this.getCause();
    }

    @Override
    public String toString() {
        String className = this.getClass().getSimpleName();
        return "[" + className + "] " + this.getLocalizedMessage() + "\n";
    }

    public static final RuntimeException unchecked(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Exception) {
            throw new ExceptionAdapter((Exception)e);
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        Assert.AssertNamespace.assertFail("uncheck: Unsupported Throwable: " + e);
        return null;
    }

    @Deprecated
    public static RuntimeException uncheckedTODO(Throwable e) {
        return ExceptionAdapter.unchecked(e);
    }
}

