/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.misc.CollectionUtil;

public class CoreUtil {
    public static <T> Optional<T> option(T value) {
        return Optional.ofNullable(value);
    }

    public static boolean areEqual(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o2 != null && o1.equals(o2);
    }

    public static boolean areEqual(int o1, int o2) {
        return o1 == o2;
    }

    public static boolean areEqual(double o1, double o2) {
        return o1 == o2;
    }

    public static boolean areEqualArrays(Object[] a1, Object[] a2) {
        return Arrays.equals(a1, a2);
    }

    public static <U, T extends U> U upCast(T object, Class<U> klass) {
        return object;
    }

    public static <T, D extends T> D downCast(T object, Class<D> klass) {
        return (D)object;
    }

    public static <T, D extends T> D downCast(T object) {
        return (D)object;
    }

    public static <T> T blindCast(Object object) {
        return (T)object;
    }

    public static <T> T tryCast(Object object, Class<T> klass) {
        if (klass.isInstance(object)) {
            return (T)CoreUtil.downCast(object);
        }
        return null;
    }

    public static <T> T assertCast(Object object, Class<T> klass) {
        Assert.AssertNamespace.assertTrue(object == null || klass.isInstance(object));
        return (T)object;
    }

    public static <T> T assertInstance(Object object, Class<T> klass) {
        Assert.AssertNamespace.assertTrue(klass.isInstance(object));
        return (T)object;
    }

    @SafeVarargs
    public static <T> T[] array(T ... elems) {
        return elems;
    }

    public static boolean[] arrayB(boolean ... elems) {
        return elems;
    }

    public static byte[] arrayB(byte ... elems) {
        return elems;
    }

    public static short[] arrayS(short ... elems) {
        return elems;
    }

    public static int[] arrayI(int ... elems) {
        return elems;
    }

    public static long[] arrayL(long ... elems) {
        return elems;
    }

    public static char[] arrayC(char ... elems) {
        return elems;
    }

    public static float[] arrayF(float ... elems) {
        return elems;
    }

    public static double[] arrayD(double ... elems) {
        return elems;
    }

    public static <U> Collection<U> nullToEmpty(Collection<U> coll) {
        return coll == null ? Collections.EMPTY_LIST : coll;
    }

    public static <E> Iterable<E> nullToEmpty(Iterable<E> coll) {
        return coll == null ? Collections.EMPTY_LIST : coll;
    }

    public static <E> Indexable<E> nullToEmpty(Indexable<E> coll) {
        return coll == null ? CollectionUtil.EMPTY_INDEXABLE : coll;
    }

    public static <T> T[] arrayFrom(Collection<? extends T> list, Class<T> cpType) {
        return ArrayUtil.createFrom(list, cpType);
    }

    @SafeVarargs
    public static <T> List<T> listFrom(T ... array) {
        return Collections.unmodifiableList(CollectionUtil.createArrayList(array));
    }

    @SafeVarargs
    public static <T> Indexable<T> list(T ... array) {
        return CollectionUtil.createArrayList(array);
    }
}

