/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.core;

import java.text.MessageFormat;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;

public class CommonException
extends Exception {
    private static final long serialVersionUID = -7324639626503261646L;

    public static CommonException fromMsgFormat(String pattern, Object ... arguments) {
        return new CommonException(MessageFormat.format(pattern, arguments));
    }

    public CommonException(String message) {
        this(Assert.AssertNamespace.assertNotNull(message), null);
    }

    public CommonException(String message, Throwable cause) {
        super(Assert.AssertNamespace.assertNotNull(message), cause);
    }

    public StatusException toStatusException() {
        return this.toStatusException(Severity.ERROR);
    }

    public StatusException toStatusException(Severity severity) {
        if (this instanceof StatusException) {
            return (StatusException)this;
        }
        return new StatusException(severity, this.getMessage(), this.getCause());
    }

    public String getSingleLineRender() {
        return new ExceptionStringRenderer(false).getLineRender(this);
    }

    public String getMultiLineRender() {
        return new ExceptionStringRenderer(true).getLineRender(this);
    }

    public static class ExceptionStringRenderer {
        public final boolean separateWithNewLines;

        public ExceptionStringRenderer(boolean separateWithNewLines) {
            this.separateWithNewLines = separateWithNewLines;
        }

        public String getLineRender(Throwable exception) {
            StringBuilder sb = new StringBuilder();
            this.renderToString(sb, exception);
            return sb.toString();
        }

        public void renderToString(StringBuilder sb, Throwable exception) {
            String message = exception.getMessage();
            if (message != null) {
                sb.append(message);
            } else {
                sb.append("[" + exception.getClass().getSimpleName() + "]");
            }
            Throwable cause = exception.getCause();
            if (cause != null) {
                this.renderCause(sb, message, cause);
            }
        }

        public void renderCause(StringBuilder sb, String message, Throwable cause) {
            if (message == null) {
                sb.append(" ");
            } else if (!message.endsWith(":") && !message.endsWith(": ")) {
                sb.append(": ");
            }
            if (this.separateWithNewLines) {
                sb.append("\n");
            }
            this.renderToString(sb, cause);
        }
    }
}

