/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.core;

import melnorme.utilbox.core.CoreUtil;

public class Assert {
    protected static final AssertHandler assertHandler;
    public static boolean assertionFailureExpected;

    static {
        assertionFailureExpected = false;
        String assertHandlerStr = System.getProperty(String.valueOf(Assert.class.getName()) + ".handler");
        if (assertHandlerStr == null) {
            assertHandler = new AssertHandler();
        } else if (assertHandlerStr.equals("disable") || assertHandlerStr.equals("null")) {
            assertHandler = null;
        } else {
            try {
                Class<?> klass = Class.forName(assertHandlerStr);
                Object handler = klass.newInstance();
                if (handler instanceof Runnable) {
                    final Runnable runnableHandler = (Runnable)handler;
                    assertHandler = new AssertHandler(){

                        @Override
                        protected void handleAssert(String message) {
                            runnableHandler.run();
                        }
                    };
                } else {
                    assertHandler = (AssertHandler)CoreUtil.downCast(handler);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static void checkAssertion(boolean condition, String message) {
        if (assertHandler != null && !condition) {
            if (assertionFailureExpected) {
                assertHandler.handleAssert(message);
            } else {
                assertHandler.handleAssert(message);
            }
        }
    }

    public static void isTrue(boolean condition, String message) {
        Assert.checkAssertion(condition, message);
    }

    public static void isTrue(boolean expression) {
        Assert.checkAssertion(expression, null);
    }

    public static void isNotNull(Object object, String message) {
        Assert.checkAssertion(object != null, message);
    }

    public static void isNotNull(Object object) {
        Assert.checkAssertion(object != null, null);
    }

    public static void equals(Object object1, Object object2) {
        Assert.checkAssertion(object1.equals(object2), null);
    }

    public static RuntimeException fail(String message) {
        Assert.checkAssertion(false, message);
        return new AssertFailedException(message);
    }

    public static RuntimeException fail() {
        Assert.checkAssertion(false, null);
        return new AssertFailedException(null);
    }

    public static RuntimeException unreachable() {
        return Assert.fail("Unreachable code.");
    }

    public static class AssertFailedException
    extends RuntimeException {
        public AssertFailedException(String message) {
            super(message);
        }

        @Override
        public String toString() {
            String message = this.getLocalizedMessage();
            return String.valueOf(AssertFailedException.class.getSimpleName()) + (message == null ? "" : ": " + message);
        }
    }

    public static class AssertHandler {
        protected void handleAssert(String message) {
            throw new AssertFailedException(message);
        }
    }

    public static class AssertNamespace {
        public static void assertTrue(boolean condition, String message) {
            Assert.checkAssertion(condition, message);
        }

        public static void assertTrue(boolean expression) {
            Assert.checkAssertion(expression, null);
        }

        public static void assertNotNull(Object object, String message) {
            Assert.checkAssertion(object != null, message);
        }

        public static <T> T assertNotNull(T object) {
            Assert.checkAssertion(object != null, null);
            return object;
        }

        public static void assertEquals(Object object1, Object object2) {
            Assert.checkAssertion(object1.equals(object2), null);
        }

        public static void assertAreEqual(Object object1, Object object2) {
            Assert.checkAssertion(CoreUtil.areEqual(object1, object2), null);
        }

        public static RuntimeException assertFail(String message) {
            Assert.checkAssertion(false, message);
            return new AssertFailedException(message);
        }

        public static RuntimeException assertFail() {
            Assert.checkAssertion(false, null);
            return new AssertFailedException(null);
        }

        public static RuntimeException assertUnreachable() {
            return Assert.fail("Unreachable code.");
        }
    }
}

