/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.concurrency;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import melnorme.utilbox.concurrency.FutureTaskX;
import melnorme.utilbox.concurrency.FutureX;
import melnorme.utilbox.concurrency.ICommonExecutor;
import melnorme.utilbox.concurrency.NamingThreadFactory;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.fntypes.CallableX;
import melnorme.utilbox.core.fntypes.OperationCallable;
import melnorme.utilbox.core.fntypes.OperationResult;
import melnorme.utilbox.misc.MiscUtil;

public class ThreadPoolExecutorExt
extends ThreadPoolExecutor
implements ExecutorService,
ICommonExecutor {
    protected final String name;
    protected final UncaughtExceptionHandler uncaughtExceptionHandler;
    protected final AtomicInteger executeCount = new AtomicInteger(0);

    public ThreadPoolExecutorExt(int corePoolSize, int maximumPoolSize, BlockingQueue<Runnable> workQueue, String name, UncaughtExceptionHandler ueHandler) {
        this(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, workQueue, name, ueHandler);
    }

    public ThreadPoolExecutorExt(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String name, UncaughtExceptionHandler ueHandler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new ExecutorThreadFactory(name, ueHandler));
        this.name = Assert.AssertNamespace.assertNotNull(name);
        this.uncaughtExceptionHandler = Assert.AssertNamespace.assertNotNull(ueHandler);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSubmittedTaskCount() {
        return this.executeCount.get();
    }

    @Override
    public void execute(Runnable command) {
        this.executeCount.incrementAndGet();
        super.execute(command);
    }

    @Override
    public void submitTask(FutureTaskX<?, RuntimeException> futureTask) {
        ThreadPoolExecutorExt.submitTo(this, futureTask);
    }

    public static <FT extends FutureTaskX<?, ?>> FT submitTo(Executor executor, FT futureTask2) {
        executor.execute(futureTask2.asFutureTask());
        return futureTask2;
    }

    @Override
    public List<Runnable> shutdownNowAndCancelAll() {
        List<Runnable> remaining = super.shutdownNow();
        for (Runnable runnable : remaining) {
            if (!(runnable instanceof FutureTask)) continue;
            FutureTask futureTask = (FutureTask)runnable;
            futureTask.cancel(true);
        }
        return remaining;
    }

    @Override
    public <RET, EXC extends Exception> FutureX<RET, EXC> submitX(CallableX<RET, EXC> callable) {
        return ThreadPoolExecutorExt.submitTo(this, new FutureTaskX<RET, EXC>(callable));
    }

    @Override
    public <RET> ICommonExecutor.CommonFuture<RET> submitOp(OperationCallable<RET> opCallable) {
        return ThreadPoolExecutorExt.submitTo(this, new CommonResultFutureTask(opCallable.toResultSupplier()));
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        if (throwable == null && runnable instanceof Future) {
            Future future = (Future)((Object)runnable);
            Assert.AssertNamespace.assertTrue(future.isDone());
            try {
                future.get();
            }
            catch (InterruptedException ie) {
                throw Assert.AssertNamespace.assertFail();
            }
            catch (CancellationException ce) {
                Assert.AssertNamespace.assertTrue(future.isCancelled());
                return;
            }
            catch (ExecutionException ee) {
                Throwable futureThrowable = ee.getCause();
                if (!MiscUtil.isUncheckedException(futureThrowable)) {
                    return;
                }
                this.handleUnexpectedException(futureThrowable);
            }
        }
    }

    protected final void handleUnexpectedException(Throwable throwable) {
        this.uncaughtExceptionHandler.accept(throwable);
    }

    protected class CommonResultFutureTask<RET>
    extends FutureTaskX<OperationResult<RET>, RuntimeException>
    implements ICommonExecutor.CommonFuture<RET> {
        public CommonResultFutureTask(CallableX<OperationResult<RET>, RuntimeException> callable) {
            super(callable);
        }

        public CommonResultFutureTask<RET> submitTo(Executor executor) {
            return ThreadPoolExecutorExt.submitTo(executor, this);
        }
    }

    public static class ExecutorThreadFactory
    extends NamingThreadFactory {
        protected final UncaughtExceptionHandler ueHandler;

        public ExecutorThreadFactory(String poolName, UncaughtExceptionHandler ueHandler) {
            super(poolName);
            this.ueHandler = ueHandler;
        }

        @Override
        public Thread newThread(Runnable runable) {
            Thread newThread = super.newThread(runable);
            newThread.setUncaughtExceptionHandler((thread, throwable) -> this.ueHandler.accept(throwable));
            return newThread;
        }
    }

    public static interface UncaughtExceptionHandler
    extends Consumer<Throwable> {
    }
}

