/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.concurrency;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import melnorme.utilbox.concurrency.AbstractFuture2;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;

public class ResultFuture<DATA>
extends AbstractFuture2<DATA> {
    protected final CountDownLatch completionLatch = new CountDownLatch(1);
    protected final Object lock = new Object();
    protected volatile ResultStatus status = ResultStatus.INITIAL;
    protected volatile DATA result;

    @Override
    public boolean isDone() {
        return this.status != ResultStatus.INITIAL;
    }

    public boolean isCompleted() {
        return this.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.status == ResultStatus.CANCELLED;
    }

    public CountDownLatch getCompletionLatch() {
        return this.completionLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(DATA result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDone()) {
                this.handleReSetResult();
                return;
            }
            this.result = result;
            this.status = ResultStatus.RESULT_SET;
            this.completionLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (!this.isDone()) break block4;
                return false;
            }
            this.status = ResultStatus.CANCELLED;
            this.completionLatch.countDown();
            return true;
        }
    }

    protected void handleReSetResult() {
        throw Assert.AssertNamespace.assertFail();
    }

    public void awaitCompletion() throws InterruptedException {
        this.completionLatch.await();
    }

    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean success = this.completionLatch.await(timeout, unit);
        if (!success) {
            throw new TimeoutException();
        }
    }

    @Override
    public DATA awaitResult() throws OperationCancellation, InterruptedException {
        this.awaitCompletion();
        return this.getResult_afterCompletion();
    }

    @Override
    public DATA awaitResult(long timeout, TimeUnit unit) throws OperationCancellation, InterruptedException, TimeoutException {
        this.awaitCompletion(timeout, unit);
        return this.getResult_afterCompletion();
    }

    protected DATA getResult_afterCompletion() throws OperationCancellation {
        if (this.isCancelled()) {
            throw new OperationCancellation();
        }
        return this.result;
    }

    public static class LatchFuture
    extends ResultFuture<Object> {
        public void setCompleted() {
            this.setResult(null);
        }

        @Override
        protected void handleReSetResult() {
        }
    }

    public static class NonNullResultFuture<DATA>
    extends ResultFuture<DATA> {
        @Override
        public void setResult(DATA result) {
            Assert.AssertNamespace.assertNotNull(result);
            super.setResult(result);
        }
    }

    public static enum ResultStatus {
        INITIAL,
        RESULT_SET,
        CANCELLED;

    }
}

