/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.concurrency;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamingThreadFactory
implements ThreadFactory {
    protected final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    protected final String poolName;
    protected boolean useThreadNumber;
    protected final AtomicInteger threadNumber = new AtomicInteger(1);

    public NamingThreadFactory(String poolName) {
        this(poolName, false);
    }

    public NamingThreadFactory(String poolName, boolean useThreadNumber) {
        this.poolName = poolName;
        this.useThreadNumber = useThreadNumber;
    }

    @Override
    public Thread newThread(Runnable runable) {
        Thread thread = this.defaultThreadFactory.newThread(runable);
        thread.setName(this.getThreadName());
        return thread;
    }

    protected String getThreadName() {
        if (this.useThreadNumber) {
            return String.valueOf(this.poolName) + "-" + this.threadNumber.getAndIncrement();
        }
        return this.poolName;
    }
}

