/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.concurrency;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import melnorme.utilbox.concurrency.FutureX;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.concurrency.ThreadPoolExecutorExt;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.fntypes.CallableX;
import melnorme.utilbox.core.fntypes.RunnableX;

public class FutureTaskX<RET, EXC extends Exception>
extends FutureTask<RET>
implements FutureX<RET, EXC> {
    public FutureTaskX(RunnableX<EXC> runnable) {
        this(() -> {
            runnable.run();
            return null;
        });
    }

    public FutureTaskX(CallableX<RET, EXC> callable) {
        super(callable);
    }

    public FutureTask<RET> asFutureTask() {
        return this;
    }

    @Override
    public boolean cancel() {
        return super.cancel(true);
    }

    public void before_cancel(boolean mayInterruptIfRunning) {
    }

    @Override
    public RET awaitResult() throws EXC, OperationCancellation, InterruptedException {
        try {
            return (RET)this.get();
        }
        catch (CancellationException e) {
            throw new OperationCancellation();
        }
        catch (ExecutionException e) {
            throw this.rethrowCause(e);
        }
    }

    @Override
    public RET awaitResult(long timeout, TimeUnit unit) throws EXC, OperationCancellation, InterruptedException, TimeoutException {
        try {
            return (RET)this.get(timeout, unit);
        }
        catch (CancellationException e) {
            throw new OperationCancellation();
        }
        catch (ExecutionException e) {
            throw this.rethrowCause(e);
        }
    }

    protected Assert.AssertFailedException rethrowCause(ExecutionException e) throws EXC {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        Exception cause2 = (Exception)cause;
        throw cause2;
    }

    public FutureX<RET, EXC> submitTo(Executor executor) {
        return ThreadPoolExecutorExt.submitTo(executor, this);
    }
}

