/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.concurrency;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import melnorme.utilbox.concurrency.FutureTaskX;
import melnorme.utilbox.concurrency.FutureX;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.CallableX;
import melnorme.utilbox.tests.CommonTest;
import org.junit.Test;

public class FutureTask2_Test
extends CommonTest {
    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        FutureTask2_Test.assertEquals("result", this.submitAndAwaitResult(() -> "result"));
        FutureTask2_Test.verifyThrows(() -> this.submitAndAwaitResult(() -> {
            throw new CommonException("xxx1");
        }), CommonException.class, "xxx1");
        FutureTask2_Test.verifyThrows(() -> this.submitAndAwaitResult(() -> {
            throw new RuntimeException("xxx2");
        }), RuntimeException.class, "xxx2");
        this.testCancellation$();
    }

    protected void testCancellation$() throws InterruptedException, OperationCancellation {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        NeverendingCallable neverending = new NeverendingCallable();
        FutureX<Object, RuntimeException> future = new FutureTaskX<Object, RuntimeException>(neverending).submitTo(executor);
        neverending.entryLatch.await();
        future.cancel();
        Assert.AssertNamespace.assertTrue(future.isCancelled());
        FutureTask2_Test.verifyThrows(() -> {
            Object RESULT = future.awaitResult();
        }, OperationCancellation.class);
        new FutureTaskX<Object, RuntimeException>(new NeverendingCallable()).submitTo(executor);
        FutureX<Object, RuntimeException> future2 = new FutureTaskX<Object, RuntimeException>(new NeverendingCallable()).submitTo(executor);
        future2.cancel();
        Assert.AssertNamespace.assertTrue(future2.isCancelled());
        FutureTask2_Test.verifyThrows(() -> {
            Object RESULT = future2.awaitResult();
        }, OperationCancellation.class);
        executor.shutdownNow();
    }

    protected <EXC extends Exception> Object submitAndAwaitResult(CallableX<Object, EXC> callable) throws OperationCancellation, InterruptedException, EXC {
        FutureX<Object, EXC> future = new FutureTaskX<Object, EXC>(callable).submitTo(ForkJoinPool.commonPool());
        return future.awaitResult();
    }

    public static class NeverendingCallable
    implements CallableX<Object, RuntimeException> {
        protected final CountDownLatch entryLatch = new CountDownLatch(1);

        @Override
        public Object call() throws RuntimeException {
            try {
                this.entryLatch.countDown();
                new CountDownLatch(1).await();
                throw Assert.AssertNamespace.assertFail();
            }
            catch (InterruptedException e) {
                return "";
            }
        }
    }
}

