/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.concurrency;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import melnorme.utilbox.concurrency.ExecutorTaskAgent;
import melnorme.utilbox.concurrency.LatchRunnable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.tests.CommonTestExt;
import org.junit.Test;

public class ExecutorTaskAgent_Test
extends CommonTestExt {
    @Test
    public void testBasic() throws Exception {
        ExecutorTaskAgent_Test.runMultipleTimes(10, 100, () -> this.testBasic$());
    }

    public void testBasic$() throws Exception {
        Tests_ExecutorTaskAgent agent = new Tests_ExecutorTaskAgent("testShutdownNow");
        LatchRunnable firstTask = new LatchRunnable(true);
        LatchRunnable secondTask = new LatchRunnable(true);
        agent.submit(firstTask);
        Assert.AssertNamespace.assertTrue(agent.getSubmittedTaskCount() == 1L);
        Future<?> secondTaskFuture = agent.submit(secondTask);
        Assert.AssertNamespace.assertTrue(agent.getSubmittedTaskCount() == 2L);
        firstTask.awaitTaskEntry();
        Assert.AssertNamespace.assertTrue(!secondTaskFuture.isCancelled());
        List<Runnable> cancelledTasks = agent.shutdownNowAndCancelAll();
        Assert.AssertNamespace.assertTrue(cancelledTasks.size() == 1);
        Assert.AssertNamespace.assertTrue(secondTaskFuture.isCancelled());
        Assert.AssertNamespace.assertTrue(agent.isShutdown());
        Thread.sleep(1L);
        Assert.AssertNamespace.assertTrue(agent.isTerminating());
        Assert.AssertNamespace.assertTrue(!agent.isTerminated());
        firstTask.releaseAll();
        agent.awaitTermination();
        Assert.AssertNamespace.assertTrue(agent.isShutdown());
        Assert.AssertNamespace.assertTrue(!agent.isTerminating());
        Assert.AssertNamespace.assertTrue(agent.isTerminated());
        this.testShutdownNow_Interrupt();
    }

    public void testShutdownNow_Interrupt() throws InterruptedException {
        Tests_ExecutorTaskAgent agent = new Tests_ExecutorTaskAgent("testShutdownNow_Interrupt");
        LatchRunnable firstTask = new LatchRunnable(false);
        agent.submit(firstTask);
        Future<?> future = agent.submit(new LatchRunnable(true));
        firstTask.awaitTaskEntry();
        Assert.AssertNamespace.assertTrue(!future.isDone());
        List<Runnable> cancelledTasks = agent.shutdownNowAndCancelAll();
        Assert.AssertNamespace.assertTrue(cancelledTasks.size() == 1);
        Assert.AssertNamespace.assertTrue(future.isCancelled());
        agent.awaitTermination();
    }

    @Test
    public void testExceptionHandling() throws Exception {
        ExecutorTaskAgent_Test.runMultipleTimes(10, 100, () -> this.testExceptionHandling$());
    }

    public void testExceptionHandling$() throws Exception {
        Tests_ExecutorTaskAgent agent = new Tests_ExecutorTaskAgent("testExceptionHandling");
        Future<?> future = agent.submit(new LatchRunnable(false));
        future.cancel(true);
        try {
            future.get();
            Assert.AssertNamespace.assertFail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        agent.awaitPendingTasks();
        Assert.AssertNamespace.assertTrue(agent.uncaughtExceptions.size() == 0);
        Runnable npeRunnable = () -> {
            throw new RuntimeException("npeRunnable");
        };
        Callable<String> normalTask = () -> {
            throw new IOException("Some expected exception");
        };
        this.checkExceptionHandling(agent.uncaughtExceptions, agent, agent.submit(npeRunnable), RuntimeException.class, false);
        this.checkExceptionHandling(agent.uncaughtExceptions, agent, agent.submit(normalTask), IOException.class, true);
        this.checkExceptionHandling(agent.uncaughtExceptions, agent, agent.submit(() -> {
            throw new RuntimeException("---");
        }), RuntimeException.class, false);
        agent.execute(npeRunnable);
        agent.shutdown();
        agent.awaitTermination();
        while (agent.uncaughtExceptions.size() != 1) {
            Thread.sleep(20L);
        }
    }

    protected void checkExceptionHandling(LinkedBlockingQueue<Throwable> unexpectedExceptions, ExecutorTaskAgent agent, Future<?> future, Class<? extends Exception> expectedKlass, boolean isExpected) throws InterruptedException {
        try {
            future.get();
        }
        catch (ExecutionException ce) {
            Assert.AssertNamespace.assertTrue(expectedKlass.isInstance(ce.getCause()));
        }
        agent.awaitPendingTasks();
        if (expectedKlass == null || isExpected) {
            Assert.AssertNamespace.assertTrue(unexpectedExceptions.size() == 0);
            return;
        }
        Assert.AssertNamespace.assertTrue(unexpectedExceptions.size() == 1);
        Throwable removed = (Throwable)unexpectedExceptions.remove();
        Assert.AssertNamespace.assertTrue(expectedKlass.isInstance(removed));
    }

    public static class Tests_ExecutorTaskAgent
    extends ExecutorTaskAgent {
        protected final LinkedBlockingQueue<Throwable> uncaughtExceptions;

        public Tests_ExecutorTaskAgent(String name) {
            this(new LinkedBlockingQueue<Throwable>(), name);
        }

        protected Tests_ExecutorTaskAgent(LinkedBlockingQueue<Throwable> uncaughtExceptions, String name) {
            super("TestsExecutor." + name, throwable -> {
                if (throwable != null) {
                    uncaughtExceptions.add((Throwable)throwable);
                }
            });
            this.uncaughtExceptions = uncaughtExceptions;
        }

        @Override
        public void awaitTermination() throws InterruptedException {
            super.awaitTermination();
        }
    }
}

