/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections.iter;

import java.util.ListIterator;
import melnorme.utilbox.collections.Indexable;

public class ImmutableListIterator<E>
implements ListIterator<E> {
    protected final Indexable<E> indexable;
    protected int cursor = 0;

    public ImmutableListIterator(Indexable<E> indexable, int index) {
        this.indexable = indexable;
        this.cursor = index;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.indexable.size();
    }

    @Override
    public E next() {
        return this.indexable.get(this.cursor++);
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    @Override
    public E previous() {
        return this.indexable.get(this.cursor--);
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException();
    }
}

